/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter;

import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.activiti.bpmn.converter.BaseBpmnXMLConverter;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.child.ScriptTextParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.ScriptTask;
import org.apache.commons.lang3.StringUtils;

public class ScriptTaskXMLConverter
extends BaseBpmnXMLConverter {
    protected Map<String, BaseChildElementParser> childParserMap = new HashMap<String, BaseChildElementParser>();

    public ScriptTaskXMLConverter() {
        ScriptTextParser scriptTextParser = new ScriptTextParser();
        this.childParserMap.put(scriptTextParser.getElementName(), scriptTextParser);
    }

    @Override
    public Class<? extends BaseElement> getBpmnElementType() {
        return ScriptTask.class;
    }

    @Override
    protected String getXMLElementName() {
        return "scriptTask";
    }

    @Override
    protected BaseElement convertXMLToElement(XMLStreamReader xtr, BpmnModel model) throws Exception {
        String autoStoreVariables;
        ScriptTask scriptTask = new ScriptTask();
        BpmnXMLUtil.addXMLLocation(scriptTask, xtr);
        scriptTask.setScriptFormat(xtr.getAttributeValue(null, "scriptFormat"));
        scriptTask.setResultVariable(xtr.getAttributeValue("http://activiti.org/bpmn", "resultVariable"));
        if (StringUtils.isEmpty((CharSequence)scriptTask.getResultVariable())) {
            scriptTask.setResultVariable(xtr.getAttributeValue("http://activiti.org/bpmn", "resultVariableName"));
        }
        if (StringUtils.isNotEmpty((CharSequence)(autoStoreVariables = xtr.getAttributeValue("http://activiti.org/bpmn", "autoStoreVariables")))) {
            scriptTask.setAutoStoreVariables(Boolean.valueOf(autoStoreVariables));
        }
        this.parseChildElements(this.getXMLElementName(), scriptTask, this.childParserMap, model, xtr);
        return scriptTask;
    }

    @Override
    protected void writeAdditionalAttributes(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ScriptTask scriptTask = (ScriptTask)element;
        this.writeDefaultAttribute("scriptFormat", scriptTask.getScriptFormat(), xtw);
        this.writeQualifiedAttribute("resultVariable", scriptTask.getResultVariable(), xtw);
        this.writeQualifiedAttribute("autoStoreVariables", String.valueOf(scriptTask.isAutoStoreVariables()), xtw);
    }

    @Override
    protected void writeAdditionalChildElements(BaseElement element, BpmnModel model, XMLStreamWriter xtw) throws Exception {
        ScriptTask scriptTask = (ScriptTask)element;
        if (StringUtils.isNotEmpty((CharSequence)scriptTask.getScript())) {
            xtw.writeStartElement("script");
            xtw.writeCData(scriptTask.getScript());
            xtw.writeEndElement();
        }
    }
}

