/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.ActivitiListener;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FieldExtension;
import org.activiti.bpmn.model.SendTask;
import org.activiti.bpmn.model.ServiceTask;
import org.apache.commons.lang3.StringUtils;

public class FieldExtensionParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "field";
    }

    @Override
    public boolean accepts(BaseElement element) {
        return element instanceof ActivitiListener || element instanceof ServiceTask || element instanceof SendTask;
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!this.accepts(parentElement)) {
            return;
        }
        FieldExtension extension = new FieldExtension();
        BpmnXMLUtil.addXMLLocation(extension, xtr);
        extension.setFieldName(xtr.getAttributeValue(null, "name"));
        if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "stringValue"))) {
            extension.setStringValue(xtr.getAttributeValue(null, "stringValue"));
        } else if (StringUtils.isNotEmpty((CharSequence)xtr.getAttributeValue(null, "expression"))) {
            extension.setExpression(xtr.getAttributeValue(null, "expression"));
        } else {
            boolean readyWithFieldExtension = false;
            try {
                while (!readyWithFieldExtension && xtr.hasNext()) {
                    xtr.next();
                    if (xtr.isStartElement() && "string".equalsIgnoreCase(xtr.getLocalName())) {
                        extension.setStringValue(xtr.getElementText().trim());
                        continue;
                    }
                    if (xtr.isStartElement() && "expression".equalsIgnoreCase(xtr.getLocalName())) {
                        extension.setExpression(xtr.getElementText().trim());
                        continue;
                    }
                    if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                    readyWithFieldExtension = true;
                }
            }
            catch (Exception e) {
                LOGGER.warn("Error parsing field extension child elements", (Throwable)e);
            }
        }
        if (parentElement instanceof ActivitiListener) {
            ((ActivitiListener)parentElement).getFieldExtensions().add(extension);
        } else if (parentElement instanceof ServiceTask) {
            ((ServiceTask)parentElement).getFieldExtensions().add(extension);
        } else {
            ((SendTask)parentElement).getFieldExtensions().add(extension);
        }
    }
}

