/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.child;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.converter.child.BaseChildElementParser;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.Activity;
import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.DataSpec;
import org.activiti.bpmn.model.IOSpecification;
import org.activiti.bpmn.model.Process;
import org.apache.commons.lang3.StringUtils;

public class IOSpecificationParser
extends BaseChildElementParser {
    @Override
    public String getElementName() {
        return "ioSpecification";
    }

    @Override
    public void parseChildElement(XMLStreamReader xtr, BaseElement parentElement, BpmnModel model) throws Exception {
        if (!(parentElement instanceof Activity) && !(parentElement instanceof Process)) {
            return;
        }
        IOSpecification ioSpecification = new IOSpecification();
        BpmnXMLUtil.addXMLLocation(ioSpecification, xtr);
        boolean readyWithIOSpecification = false;
        try {
            while (!readyWithIOSpecification && xtr.hasNext()) {
                DataSpec dataSpec;
                xtr.next();
                if (xtr.isStartElement() && "dataInput".equalsIgnoreCase(xtr.getLocalName())) {
                    dataSpec = new DataSpec();
                    BpmnXMLUtil.addXMLLocation(dataSpec, xtr);
                    dataSpec.setId(xtr.getAttributeValue(null, "id"));
                    dataSpec.setName(xtr.getAttributeValue(null, "name"));
                    dataSpec.setItemSubjectRef(this.parseItemSubjectRef(xtr.getAttributeValue(null, "itemSubjectRef"), model));
                    ioSpecification.getDataInputs().add(dataSpec);
                    continue;
                }
                if (xtr.isStartElement() && "dataOutput".equalsIgnoreCase(xtr.getLocalName())) {
                    dataSpec = new DataSpec();
                    BpmnXMLUtil.addXMLLocation(dataSpec, xtr);
                    dataSpec.setId(xtr.getAttributeValue(null, "id"));
                    dataSpec.setName(xtr.getAttributeValue(null, "name"));
                    dataSpec.setItemSubjectRef(this.parseItemSubjectRef(xtr.getAttributeValue(null, "itemSubjectRef"), model));
                    ioSpecification.getDataOutputs().add(dataSpec);
                    continue;
                }
                if (xtr.isStartElement() && "dataInputRefs".equalsIgnoreCase(xtr.getLocalName())) {
                    String dataInputRefs = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)dataInputRefs)) continue;
                    ioSpecification.getDataInputRefs().add(dataInputRefs.trim());
                    continue;
                }
                if (xtr.isStartElement() && "dataOutputRefs".equalsIgnoreCase(xtr.getLocalName())) {
                    String dataOutputRefs = xtr.getElementText();
                    if (!StringUtils.isNotEmpty((CharSequence)dataOutputRefs)) continue;
                    ioSpecification.getDataOutputRefs().add(dataOutputRefs.trim());
                    continue;
                }
                if (!xtr.isEndElement() || !this.getElementName().equalsIgnoreCase(xtr.getLocalName())) continue;
                readyWithIOSpecification = true;
            }
        }
        catch (Exception e) {
            LOGGER.warn("Error parsing ioSpecification child elements", (Throwable)e);
        }
        if (parentElement instanceof Process) {
            ((Process)parentElement).setIoSpecification(ioSpecification);
        } else {
            ((Activity)parentElement).setIoSpecification(ioSpecification);
        }
    }

    protected String parseItemSubjectRef(String itemSubjectRef, BpmnModel model) {
        String result = null;
        if (StringUtils.isNotEmpty((CharSequence)itemSubjectRef)) {
            int indexOfP = itemSubjectRef.indexOf(58);
            if (indexOfP != -1) {
                String prefix = itemSubjectRef.substring(0, indexOfP);
                String resolvedNamespace = model.getNamespace(prefix);
                result = resolvedNamespace + ":" + itemSubjectRef.substring(indexOfP + 1);
            } else {
                result = model.getTargetNamespace() + ":" + itemSubjectRef;
            }
        }
        return result;
    }
}

