/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.bpmn.converter.parser;

import javax.xml.stream.XMLStreamReader;
import org.activiti.bpmn.constants.BpmnXMLConstants;
import org.activiti.bpmn.converter.util.BpmnXMLUtil;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.FlowElement;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Resource;
import org.activiti.bpmn.model.UserTask;

public class ResourceParser
implements BpmnXMLConstants {
    public void parse(XMLStreamReader xtr, BpmnModel model) throws Exception {
        Resource resource;
        String resourceId = xtr.getAttributeValue(null, "id");
        String resourceName = xtr.getAttributeValue(null, "name");
        if (model.containsResourceId(resourceId)) {
            resource = model.getResource(resourceId);
            resource.setName(resourceName);
            for (Process process : model.getProcesses()) {
                for (FlowElement fe : process.getFlowElements()) {
                    if (!(fe instanceof UserTask) || !((UserTask)fe).getCandidateGroups().contains(resourceId)) continue;
                    ((UserTask)fe).getCandidateGroups().remove(resourceId);
                    ((UserTask)fe).getCandidateGroups().add(resourceName);
                }
            }
        } else {
            resource = new Resource(resourceId, resourceName);
            model.addResource(resource);
        }
        BpmnXMLUtil.addXMLLocation(resource, xtr);
    }
}

