/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.bpmn.parser.handler;

import org.activiti.bpmn.model.BaseElement;
import org.activiti.bpmn.model.BoundaryEvent;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.IntermediateCatchEvent;
import org.activiti.bpmn.model.Message;
import org.activiti.bpmn.model.MessageEventDefinition;
import org.activiti.bpmn.model.StartEvent;
import org.activiti.engine.impl.bpmn.parser.BpmnParse;
import org.activiti.engine.impl.bpmn.parser.EventSubscriptionDeclaration;
import org.activiti.engine.impl.bpmn.parser.handler.AbstractBpmnParseHandler;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.ScopeImpl;

public class MessageEventDefinitionParseHandler
extends AbstractBpmnParseHandler<MessageEventDefinition> {
    @Override
    public Class<? extends BaseElement> getHandledType() {
        return MessageEventDefinition.class;
    }

    @Override
    protected void executeParse(BpmnParse bpmnParse, MessageEventDefinition messageDefinition) {
        String messageRef;
        BpmnModel bpmnModel = bpmnParse.getBpmnModel();
        if (bpmnModel.containsMessageId(messageRef = messageDefinition.getMessageRef())) {
            Message message = bpmnModel.getMessage(messageRef);
            messageDefinition.setMessageRef(message.getName());
            messageDefinition.setExtensionElements(message.getExtensionElements());
        }
        EventSubscriptionDeclaration eventSubscription = new EventSubscriptionDeclaration(messageDefinition.getMessageRef(), "message");
        ScopeImpl scope = bpmnParse.getCurrentScope();
        ActivityImpl activity = bpmnParse.getCurrentActivity();
        if (bpmnParse.getCurrentFlowElement() instanceof StartEvent && bpmnParse.getCurrentSubProcess() != null) {
            ScopeImpl catchingScope = ((ActivityImpl)scope).getParent();
            EventSubscriptionDeclaration eventSubscriptionDeclaration = new EventSubscriptionDeclaration(messageDefinition.getMessageRef(), "message");
            eventSubscriptionDeclaration.setActivityId(activity.getId());
            eventSubscriptionDeclaration.setStartEvent(false);
            this.addEventSubscriptionDeclaration(bpmnParse, eventSubscriptionDeclaration, messageDefinition, catchingScope);
        } else if (bpmnParse.getCurrentFlowElement() instanceof StartEvent) {
            activity.setProperty("type", "messageStartEvent");
            eventSubscription.setStartEvent(true);
            eventSubscription.setActivityId(activity.getId());
            this.addEventSubscriptionDeclaration(bpmnParse, eventSubscription, messageDefinition, bpmnParse.getCurrentProcessDefinition());
        } else if (bpmnParse.getCurrentFlowElement() instanceof IntermediateCatchEvent) {
            activity.setProperty("type", "intermediateMessageCatch");
            if (this.getPrecedingEventBasedGateway(bpmnParse, (IntermediateCatchEvent)bpmnParse.getCurrentFlowElement()) != null) {
                eventSubscription.setActivityId(activity.getId());
                this.addEventSubscriptionDeclaration(bpmnParse, eventSubscription, messageDefinition, activity.getParent());
            } else {
                activity.setScope(true);
                this.addEventSubscriptionDeclaration(bpmnParse, eventSubscription, messageDefinition, activity);
            }
        } else if (bpmnParse.getCurrentFlowElement() instanceof BoundaryEvent) {
            BoundaryEvent boundaryEvent = (BoundaryEvent)bpmnParse.getCurrentFlowElement();
            boolean interrupting = boundaryEvent.isCancelActivity();
            activity.setActivityBehavior(bpmnParse.getActivityBehaviorFactory().createBoundaryEventActivityBehavior(boundaryEvent, interrupting, activity));
            activity.setProperty("type", "boundaryMessage");
            EventSubscriptionDeclaration eventSubscriptionDeclaration = new EventSubscriptionDeclaration(messageDefinition.getMessageRef(), "message");
            eventSubscriptionDeclaration.setActivityId(activity.getId());
            this.addEventSubscriptionDeclaration(bpmnParse, eventSubscriptionDeclaration, messageDefinition, activity.getParent());
            if (activity.getParent() instanceof ActivityImpl) {
                ((ActivityImpl)activity.getParent()).setScope(true);
            }
        }
    }
}

