/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.cmd;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.activiti.engine.HistoryService;
import org.activiti.engine.RepositoryService;
import org.activiti.engine.RuntimeService;
import org.activiti.engine.TaskService;
import org.activiti.engine.history.HistoricActivityInstance;
import org.activiti.engine.history.HistoricActivityInstanceQuery;
import org.activiti.engine.history.HistoricTaskInstance;
import org.activiti.engine.history.HistoricTaskInstanceQuery;
import org.activiti.engine.impl.RepositoryServiceImpl;
import org.activiti.engine.impl.persistence.entity.ProcessDefinitionEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.activiti.engine.impl.pvm.PvmTransition;
import org.activiti.engine.impl.pvm.process.ActivityImpl;
import org.activiti.engine.impl.pvm.process.TransitionImpl;
import org.activiti.engine.runtime.ProcessInstance;
import org.activiti.engine.task.Task;
import org.activiti.engine.task.TaskQuery;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.exception.JiMuBizException;
import org.openoa.base.util.ProcessDefinitionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class ProcessNodeJump {
    @Autowired
    protected TaskService taskService;
    @Autowired
    private HistoryService historyService;
    @Autowired
    private RuntimeService runtimeService;
    @Autowired
    private RepositoryService repositoryService;

    public void jumpTransAction(String taskId, String endActivityId) throws Exception {
        HistoricTaskInstance currTask = (HistoricTaskInstance)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().taskId(taskId)).singleResult();
        if (currTask == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5f53\u524d\u4efb\u52a1");
        }
        ProcessInstance instance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(currTask.getProcessInstanceId()).singleResult();
        if (instance == null) {
            throw new RuntimeException("\u672a\u627e\u5230\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b");
        }
        this.cancelAllParallelTasks(instance.getId(), currTask.getTaskDefinitionKey());
        this.jumpAllParallelTasks(instance, endActivityId);
    }

    private void cancelAllParallelTasks(String processInstanceId, String taskDefinitionKey) {
        List activeTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(processInstanceId)).list();
        for (Task task : activeTasks) {
            this.taskService.setAssignee(task.getId(), "\u81ea\u52a8\u8df3\u8fc7");
            this.taskService.complete(task.getId());
        }
    }

    private void jumpAllParallelTasks(ProcessInstance instance, String targetActivityId) throws Exception {
        List parallelTasks = ((TaskQuery)this.taskService.createTaskQuery().processInstanceId(instance.getId())).list();
        for (Task task : parallelTasks) {
            this.jumpToActivity(task.getId(), targetActivityId);
        }
    }

    private void jumpToActivity(String taskId, String targetActivityId) throws Exception {
        ActivityImpl targetActivity = this.findActivitiImpl(taskId, targetActivityId);
        TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> originalTransitions = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        newTransition.setDestination(targetActivity);
        this.taskService.complete(taskId);
        targetActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, originalTransitions);
    }

    public void commitProcess(String taskId, Map<String, Object> variables, String activityId) {
        if (variables == null) {
            variables = new HashMap<String, Object>();
        }
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            this.taskService.complete(taskId, variables);
        } else {
            try {
                this.turnTransition(taskId, activityId, variables);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void turnTransition(String taskId, String activityId, Map<String, Object> variables) throws Exception {
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        ActivityImpl pointActivity = this.findActivitiImpl(taskId, activityId);
        newTransition.setDestination(pointActivity);
        this.taskService.complete(taskId, variables);
        pointActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, oriPvmTransitionList);
    }

    private void deleteCompletedTasks(String processInstanceId, HistoricTaskInstance historicTaskInstance) {
        List finishedTasks = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(historicTaskInstance.getTaskDefinitionKey())).finished().list();
        ArrayList<ActivityImpl> allUserTasks = new ArrayList<ActivityImpl>();
        ActivityImpl closestStartParallelGateway = ProcessDefinitionUtils.findClosestStartParallelGateway(historicTaskInstance.getProcessInstanceId());
        if (closestStartParallelGateway != null) {
            ActivityImpl joinParallelGateway = ProcessDefinitionUtils.findJoinParallelGatewayRecursively(closestStartParallelGateway);
            ProcessDefinitionUtils.findUserTasksBetweenGatewaysRecursively(closestStartParallelGateway, joinParallelGateway, allUserTasks);
        }
        if (!CollectionUtils.isEmpty(allUserTasks)) {
            for (ActivityImpl activityImpl : allUserTasks) {
                List historicTaskInstances = ((HistoricTaskInstanceQuery)((HistoricTaskInstanceQuery)this.historyService.createHistoricTaskInstanceQuery().processInstanceId(processInstanceId)).taskDefinitionKey(activityImpl.getId())).list();
                if (CollectionUtils.isEmpty(historicTaskInstances)) continue;
                for (HistoricTaskInstance historicActivityInstance : historicTaskInstances) {
                    this.historyService.deleteHistoricTaskInstance(historicActivityInstance.getId());
                }
            }
        } else {
            for (HistoricTaskInstance task : finishedTasks) {
                this.historyService.deleteHistoricTaskInstance(task.getId());
            }
        }
    }

    private void turnTransitionV2(String taskId, String activityId, Map<String, Object> variables) throws Exception {
        String startGatewayId;
        ActivityImpl currActivity = this.findActivitiImpl(taskId, null);
        ActivityImpl targetActivity = this.findActivitiImpl(taskId, activityId);
        if ("parallelGateway".equals(targetActivity.getProperty("type")) && (startGatewayId = this.findParallelGatewayId(targetActivity)) != null) {
            targetActivity = this.findActivitiImpl(taskId, startGatewayId);
        }
        List<PvmTransition> oriPvmTransitionList = this.clearTransition(currActivity);
        TransitionImpl newTransition = currActivity.createOutgoingTransition();
        newTransition.setDestination(targetActivity);
        this.taskService.complete(taskId, variables);
        targetActivity.getIncomingTransitions().remove(newTransition);
        this.restoreTransition(currActivity, oriPvmTransitionList);
    }

    private void restoreTransition(ActivityImpl activityImpl, List<PvmTransition> oriPvmTransitionList) {
        List<PvmTransition> pvmTransitionList = activityImpl.getOutgoingTransitions();
        pvmTransitionList.clear();
        for (PvmTransition pvmTransition : oriPvmTransitionList) {
            pvmTransitionList.add(pvmTransition);
        }
    }

    public ActivityImpl findActivitiImpl(String taskId, String activityId) throws Exception {
        ProcessDefinitionEntity processDefinition = this.findProcessDefinitionEntityByTaskId(taskId);
        if (StringUtils.isEmpty((CharSequence)activityId)) {
            activityId = this.findTaskById(taskId).getTaskDefinitionKey();
        }
        if (activityId.toUpperCase().equals("END")) {
            for (ActivityImpl activityImpl : processDefinition.getActivities()) {
                List<PvmTransition> pvmTransitionList = activityImpl.getOutgoingTransitions();
                if (!pvmTransitionList.isEmpty()) continue;
                return activityImpl;
            }
        }
        ActivityImpl activityImpl = processDefinition.findActivity(activityId);
        return activityImpl;
    }

    private TaskEntity findTaskById(String taskId) throws Exception {
        TaskEntity task = (TaskEntity)((TaskQuery)this.taskService.createTaskQuery().taskId(taskId)).singleResult();
        if (task == null) {
            throw new JiMuBizException("\u4efb\u52a1\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return task;
    }

    private ProcessDefinitionEntity findProcessDefinitionEntityByTaskId(String taskId) throws Exception {
        ProcessDefinitionEntity processDefinition = (ProcessDefinitionEntity)((RepositoryServiceImpl)this.repositoryService).getDeployedProcessDefinition(this.findTaskById(taskId).getProcessDefinitionId());
        if (processDefinition == null) {
            throw new Exception("\u6d41\u7a0b\u5b9a\u4e49\u672a\u627e\u5230!");
        }
        return processDefinition;
    }

    private List<PvmTransition> clearTransition(ActivityImpl activityImpl) {
        ArrayList<PvmTransition> oriPvmTransitionList = new ArrayList<PvmTransition>();
        List<PvmTransition> pvmTransitionList = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : pvmTransitionList) {
            oriPvmTransitionList.add(pvmTransition);
        }
        pvmTransitionList.clear();
        return oriPvmTransitionList;
    }

    private List<ActivityImpl> iteratorBackActivity(String taskId, ActivityImpl currActivity, List<ActivityImpl> rtnList, List<ActivityImpl> tempList) throws Exception {
        ProcessInstance processInstance = this.findProcessInstanceByTaskId(taskId);
        List<PvmTransition> incomingTransitions = currActivity.getIncomingTransitions();
        ArrayList<ActivityImpl> exclusiveGateways = new ArrayList<ActivityImpl>();
        ArrayList<ActivityImpl> parallelGateways = new ArrayList<ActivityImpl>();
        for (PvmTransition pvmTransition : incomingTransitions) {
            TransitionImpl transitionImpl = (TransitionImpl)pvmTransition;
            ActivityImpl activityImpl = transitionImpl.getSource();
            String type = (String)activityImpl.getProperty("type");
            if ("parallelGateway".equals(type)) {
                String gatewayId = activityImpl.getId();
                String gatewayType = gatewayId.substring(gatewayId.lastIndexOf("_") + 1);
                if ("START".equals(gatewayType.toUpperCase())) {
                    return rtnList;
                }
                parallelGateways.add(activityImpl);
                continue;
            }
            if ("startEvent".equals(type)) {
                return rtnList;
            }
            if ("userTask".equals(type)) {
                tempList.add(activityImpl);
                continue;
            }
            if (!"exclusiveGateway".equals(type)) continue;
            currActivity = transitionImpl.getSource();
            exclusiveGateways.add(currActivity);
        }
        for (ActivityImpl activityImpl : exclusiveGateways) {
            this.iteratorBackActivity(taskId, activityImpl, rtnList, tempList);
        }
        for (ActivityImpl activityImpl : parallelGateways) {
            this.iteratorBackActivity(taskId, activityImpl, rtnList, tempList);
        }
        currActivity = this.filterNewestActivity(processInstance, tempList);
        if (currActivity != null) {
            String id = this.findParallelGatewayId(currActivity);
            if (id == null || id.equals("")) {
                rtnList.add(currActivity);
            } else {
                currActivity = this.findActivitiImpl(taskId, id);
            }
            tempList.clear();
            this.iteratorBackActivity(taskId, currActivity, rtnList, tempList);
        }
        return rtnList;
    }

    private String findParallelGatewayId(ActivityImpl activityImpl) {
        List<PvmTransition> incomingTransitions = activityImpl.getOutgoingTransitions();
        for (PvmTransition pvmTransition : incomingTransitions) {
            String gatewayId;
            String gatewayType;
            TransitionImpl transitionImpl = (TransitionImpl)pvmTransition;
            activityImpl = transitionImpl.getDestination();
            String type = (String)activityImpl.getProperty("type");
            if (!"parallelGateway".equals(type) || !"END".equals((gatewayType = (gatewayId = activityImpl.getId()).substring(gatewayId.lastIndexOf("_") + 1)).toUpperCase())) continue;
            return gatewayId.substring(0, gatewayId.lastIndexOf("_")) + "_start";
        }
        return null;
    }

    private ActivityImpl filterNewestActivity(ProcessInstance processInstance, List<ActivityImpl> tempList) {
        while (tempList.size() > 0) {
            ActivityImpl activity_1 = tempList.get(0);
            HistoricActivityInstance activityInstance_1 = this.findHistoricUserTask(processInstance, activity_1.getId());
            if (activityInstance_1 == null) {
                tempList.remove(activity_1);
                continue;
            }
            if (tempList.size() <= 1) break;
            ActivityImpl activity_2 = tempList.get(1);
            HistoricActivityInstance activityInstance_2 = this.findHistoricUserTask(processInstance, activity_2.getId());
            if (activityInstance_2 == null) {
                tempList.remove(activity_2);
                continue;
            }
            if (activityInstance_1.getEndTime().before(activityInstance_2.getEndTime())) {
                tempList.remove(activity_1);
                continue;
            }
            tempList.remove(activity_2);
        }
        if (tempList.size() > 0) {
            return tempList.get(0);
        }
        return null;
    }

    private HistoricActivityInstance findHistoricUserTask(ProcessInstance processInstance, String activityId) {
        HistoricActivityInstance rtnVal = null;
        List historicActivityInstances = ((HistoricActivityInstanceQuery)this.historyService.createHistoricActivityInstanceQuery().activityType("userTask").processInstanceId(processInstance.getId()).activityId(activityId).finished().orderByHistoricActivityInstanceEndTime().desc()).list();
        if (historicActivityInstances.size() > 0) {
            rtnVal = (HistoricActivityInstance)historicActivityInstances.get(0);
        }
        return rtnVal;
    }

    private ProcessInstance findProcessInstanceByTaskId(String taskId) throws Exception {
        ProcessInstance processInstance = (ProcessInstance)this.runtimeService.createProcessInstanceQuery().processInstanceId(this.findTaskById(taskId).getProcessInstanceId()).singleResult();
        if (processInstance == null) {
            throw new JiMuBizException("\u6d41\u7a0b\u5b9e\u4f8b\u672a\u627e\u5230!");
        }
        return processInstance;
    }
}

