/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import org.activiti.engine.ActivitiException;

public class IoUtil {
    public static byte[] readInputStream(InputStream inputStream, String inputStreamName) {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        byte[] buffer = new byte[16384];
        try {
            int bytesRead = inputStream.read(buffer);
            while (bytesRead != -1) {
                outputStream.write(buffer, 0, bytesRead);
                bytesRead = inputStream.read(buffer);
            }
        }
        catch (Exception e) {
            throw new ActivitiException("couldn't read input stream " + inputStreamName, e);
        }
        return outputStream.toByteArray();
    }

    public static String readFileAsString(String filePath) {
        byte[] buffer = new byte[(int)IoUtil.getFile(filePath).length()];
        BufferedInputStream inputStream = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(IoUtil.getFile(filePath));
            inputStream = new BufferedInputStream(fileInputStream);
            inputStream.read(buffer);
        }
        catch (Exception e) {
            try {
                throw new ActivitiException("Couldn't read file " + filePath + ": " + e.getMessage());
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(inputStream);
                IoUtil.closeSilently(fileInputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(inputStream);
        IoUtil.closeSilently(fileInputStream);
        return new String(buffer);
    }

    public static File getFile(String filePath) {
        URL url = IoUtil.class.getClassLoader().getResource(filePath);
        try {
            return new File(url.toURI());
        }
        catch (Exception e) {
            throw new ActivitiException("Couldn't get file " + filePath + ": " + e.getMessage());
        }
    }

    public static void writeStringToFile(String content, String filePath) {
        BufferedOutputStream outputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(IoUtil.getFile(filePath));
            outputStream = new BufferedOutputStream(fileOutputStream);
            outputStream.write(content.getBytes());
            outputStream.flush();
        }
        catch (Exception e) {
            try {
                throw new ActivitiException("Couldn't write file " + filePath, e);
            }
            catch (Throwable throwable) {
                IoUtil.closeSilently(outputStream);
                IoUtil.closeSilently(fileOutputStream);
                throw throwable;
            }
        }
        IoUtil.closeSilently(outputStream);
        IoUtil.closeSilently(fileOutputStream);
    }

    public static void closeSilently(InputStream inputStream) {
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeSilently(OutputStream outputStream) {
        try {
            if (outputStream != null) {
                outputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

