/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.engine.impl.variable;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.impl.context.Context;
import org.activiti.engine.impl.variable.CacheableVariable;
import org.activiti.engine.impl.variable.EntityManagerSession;
import org.activiti.engine.impl.variable.JPAEntityMappings;
import org.activiti.engine.impl.variable.ValueFields;
import org.activiti.engine.impl.variable.VariableType;

public class JPAEntityVariableType
implements VariableType,
CacheableVariable {
    public static final String TYPE_NAME = "jpa-entity";
    private JPAEntityMappings mappings = new JPAEntityMappings();
    private boolean forceCacheable = false;

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public boolean isCachable() {
        return this.forceCacheable;
    }

    @Override
    public boolean isAbleToStore(Object value) {
        if (value == null) {
            return true;
        }
        return this.mappings.isJPAEntity(value);
    }

    @Override
    public void setValue(Object value, ValueFields valueFields) {
        EntityManagerSession entityManagerSession = Context.getCommandContext().getSession(EntityManagerSession.class);
        if (entityManagerSession == null) {
            throw new ActivitiException("Cannot set JPA variable: " + EntityManagerSession.class + " not configured");
        }
        entityManagerSession.flush();
        if (value != null) {
            String className = this.mappings.getJPAClassString(value);
            String idString = this.mappings.getJPAIdString(value);
            valueFields.setTextValue(className);
            valueFields.setTextValue2(idString);
        } else {
            valueFields.setTextValue(null);
            valueFields.setTextValue2(null);
        }
    }

    @Override
    public Object getValue(ValueFields valueFields) {
        if (valueFields.getTextValue() != null && valueFields.getTextValue2() != null) {
            return this.mappings.getJPAEntity(valueFields.getTextValue(), valueFields.getTextValue2());
        }
        return null;
    }

    @Override
    public void setForceCacheable(boolean forceCachedValue) {
        this.forceCacheable = forceCachedValue;
    }
}

