/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.spring;

import org.activiti.engine.impl.cfg.TransactionContext;
import org.activiti.engine.impl.cfg.TransactionListener;
import org.activiti.engine.impl.cfg.TransactionPropagation;
import org.activiti.engine.impl.cfg.TransactionState;
import org.activiti.engine.impl.interceptor.Command;
import org.activiti.engine.impl.interceptor.CommandConfig;
import org.activiti.engine.impl.interceptor.CommandContext;
import org.activiti.engine.impl.interceptor.CommandExecutor;
import org.springframework.core.Ordered;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionSynchronization;
import org.springframework.transaction.support.TransactionSynchronizationManager;

public class SpringTransactionContext
implements TransactionContext {
    protected PlatformTransactionManager transactionManager;
    protected CommandContext commandContext;
    protected Integer transactionSynchronizationAdapterOrder;

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext) {
        this(transactionManager, commandContext, null);
    }

    public SpringTransactionContext(PlatformTransactionManager transactionManager, CommandContext commandContext, Integer transactionSynchronizationAdapterOrder) {
        this.transactionManager = transactionManager;
        this.commandContext = commandContext;
        this.transactionSynchronizationAdapterOrder = transactionSynchronizationAdapterOrder != null ? transactionSynchronizationAdapterOrder : Integer.valueOf(Integer.MAX_VALUE);
    }

    @Override
    public void commit() {
    }

    @Override
    public void rollback() {
        this.transactionManager.getTransaction(null).setRollbackOnly();
    }

    @Override
    public void addTransactionListener(TransactionState transactionState, final TransactionListener transactionListener) {
        if (transactionState.equals((Object)TransactionState.COMMITTING)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCommit(boolean readOnly) {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.COMMITTED)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void afterCommit() {
                    CommandExecutor commandExecutor = SpringTransactionContext.this.commandContext.getProcessEngineConfiguration().getCommandExecutor();
                    CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
                    commandExecutor.execute(commandConfig, new Command<Void>(){

                        @Override
                        public Void execute(CommandContext commandContext) {
                            transactionListener.execute(commandContext);
                            return null;
                        }
                    });
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLINGBACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void beforeCompletion() {
                    transactionListener.execute(SpringTransactionContext.this.commandContext);
                }
            });
        } else if (transactionState.equals((Object)TransactionState.ROLLED_BACK)) {
            TransactionSynchronizationManager.registerSynchronization((TransactionSynchronization)new TransactionSynchronizationAdapter(){

                @Override
                public void afterCompletion(int status) {
                    if (1 == status) {
                        CommandExecutor commandExecutor = SpringTransactionContext.this.commandContext.getProcessEngineConfiguration().getCommandExecutor();
                        CommandConfig commandConfig = new CommandConfig(false, TransactionPropagation.REQUIRES_NEW);
                        commandExecutor.execute(commandConfig, new Command<Void>(){

                            @Override
                            public Void execute(CommandContext commandContext) {
                                transactionListener.execute(commandContext);
                                return null;
                            }
                        });
                    }
                }
            });
        }
    }

    protected abstract class TransactionSynchronizationAdapter
    implements TransactionSynchronization,
    Ordered {
        protected TransactionSynchronizationAdapter() {
        }

        public void suspend() {
        }

        public void resume() {
        }

        public void flush() {
        }

        public void beforeCommit(boolean readOnly) {
        }

        public void beforeCompletion() {
        }

        public void afterCommit() {
        }

        public void afterCompletion(int status) {
        }

        public int getOrder() {
            return SpringTransactionContext.this.transactionSynchronizationAdapterOrder;
        }
    }
}

