/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.Process;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ValidatorImpl;

public class BpmnModelValidator
extends ValidatorImpl {
    @Override
    public void validate(BpmnModel bpmnModel, List<ValidationError> errors) {
        boolean isAtLeastOneExecutable = this.validateAtLeastOneExecutable(bpmnModel, errors);
        if (isAtLeastOneExecutable) {
            for (Process process : bpmnModel.getProcesses()) {
                if (!process.isExecutable()) {
                    this.addWarning(errors, "activiti-specific-process-definition-not-executable", process, process, "Process definition is not executable. Please verify that this is intentional.");
                }
                this.handleProcessConstraints(bpmnModel, process, errors);
            }
        }
        this.handleBPMNModelConstraints(bpmnModel, errors);
    }

    protected void handleProcessConstraints(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        if (process.getId() != null && process.getId().length() > 255) {
            this.addError(errors, "activiti-process-definition-id-too-long", process, "The id of the process definition must not contain more than 255 characters");
        }
        if (process.getName() != null && process.getName().length() > 255) {
            this.addError(errors, "activiti-process-definition-name-too-long", process, "The name of the process definition must not contain more than 255 characters");
        }
        if (process.getDocumentation() != null && process.getDocumentation().length() > 2000) {
            this.addError(errors, "activiti-process-definition-documentation-too-long", process, "The documentation of the process definition must not contain more than 2000 characters");
        }
    }

    protected void handleBPMNModelConstraints(BpmnModel bpmnModel, List<ValidationError> errors) {
        if (bpmnModel.getTargetNamespace() != null && bpmnModel.getTargetNamespace().length() > 255) {
            this.addError(errors, "activiti-bpmn-model-target-namespace-too-long", "The targetNamespace of the bpmn model must not contain more than 255 characters");
        }
    }

    protected boolean validateAtLeastOneExecutable(BpmnModel bpmnModel, List<ValidationError> errors) {
        int nrOfExecutableDefinitions = 0;
        for (Process process : bpmnModel.getProcesses()) {
            if (!process.isExecutable()) continue;
            ++nrOfExecutableDefinitions;
        }
        if (nrOfExecutableDefinitions == 0) {
            this.addError(errors, "activiti-process-definition-not-executable", "All process definition are set to be non-executable (property 'isExecutable' on process). This is not allowed.");
        }
        return nrOfExecutableDefinitions > 0;
    }
}

