/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.validation.validator.impl;

import java.util.List;
import org.activiti.bpmn.model.BpmnModel;
import org.activiti.bpmn.model.CancelEventDefinition;
import org.activiti.bpmn.model.EndEvent;
import org.activiti.bpmn.model.EventDefinition;
import org.activiti.bpmn.model.FlowElementsContainer;
import org.activiti.bpmn.model.Process;
import org.activiti.bpmn.model.Transaction;
import org.activiti.validation.ValidationError;
import org.activiti.validation.validator.ProcessLevelValidator;

public class EndEventValidator
extends ProcessLevelValidator {
    @Override
    protected void executeValidation(BpmnModel bpmnModel, Process process, List<ValidationError> errors) {
        List<EndEvent> endEvents = process.findFlowElementsOfType(EndEvent.class);
        for (EndEvent endEvent : endEvents) {
            FlowElementsContainer parent;
            EventDefinition eventDefinition;
            if (endEvent.getEventDefinitions() == null || endEvent.getEventDefinitions().isEmpty() || !((eventDefinition = endEvent.getEventDefinitions().get(0)) instanceof CancelEventDefinition) || (parent = process.findParent(endEvent)) instanceof Transaction) continue;
            this.addError(errors, "activiti-end-event-cancel-only-inside-transaction", process, endEvent, "end event with cancelEventDefinition only supported inside transaction subprocess");
        }
    }
}

