/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.constant.enums;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openoa.base.exception.JiMuBizException;

public enum BpmnConfFlagsEnum {
    NOTHING(0, "\u4e0d\u5b58\u5728"),
    HAS_NODE_LABELS(1, "\u5305\u542b\u8282\u70b9\u6807\u7b7e(\u4efb\u610f\u8282\u70b9\u5305\u542b\u6807\u7b7e)"),
    HAS_STARTUSER_CHOOSE_MODULES(2, "\u662f\u5426\u5305\u542b\u53d1\u8d77\u4eba\u81ea\u9009\u6a21\u5757"),
    HAS_DYNAMIC_CONDITIONS(4, "\u662f\u5426\u5305\u542b\u52a8\u6001\u6761\u4ef6"),
    HAS_COPY(8, "\u662f\u5426\u5305\u542b\u6284\u9001"),
    HAS_LAST_NODE_COPY(16, "\u6700\u540e\u4e00\u4e2a\u8282\u70b9\u662f\u5426\u5305\u542b\u6284\u9001");

    private final Integer code;
    private final String desc;

    private BpmnConfFlagsEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static Integer binaryOr(Integer alreadyFlags, Integer newFlag) {
        if (alreadyFlags == null) {
            alreadyFlags = 0;
        }
        return alreadyFlags | newFlag;
    }

    public static Integer binaryAndNot(Integer alreadyFlags, BpmnConfFlagsEnum flagToRemove) {
        if (flagToRemove == null) {
            return alreadyFlags;
        }
        if (alreadyFlags == null) {
            alreadyFlags = 0;
        }
        return alreadyFlags & ~flagToRemove.code.intValue();
    }

    public static List<BpmnConfFlagsEnum> flagEnumsByCode(Integer flags) {
        if (flags == null) {
            flags = 0;
        }
        Set<Integer> integers = BpmnConfFlagsEnum.splitBinary(flags);
        ArrayList<BpmnConfFlagsEnum> results = new ArrayList<BpmnConfFlagsEnum>();
        for (BpmnConfFlagsEnum value : BpmnConfFlagsEnum.values()) {
            if (!integers.contains(value.code)) continue;
            results.add(value);
        }
        return results;
    }

    public static boolean hasFlag(Integer alreadyFlags, BpmnConfFlagsEnum flag) {
        if (alreadyFlags == null) {
            alreadyFlags = 0;
        }
        if (flag == null) {
            throw new JiMuBizException("\u8981\u5224\u65ad\u7684\u679a\u4e3e\u4e0d\u5b58\u5728!");
        }
        List<BpmnConfFlagsEnum> bpmnConfFlags = BpmnConfFlagsEnum.flagEnumsByCode(alreadyFlags);
        for (BpmnConfFlagsEnum confFlagsEnum : bpmnConfFlags) {
            if (confFlagsEnum != flag) continue;
            return true;
        }
        return false;
    }

    private static Set<Integer> splitBinary(int number) {
        HashSet<Integer> parts = new HashSet<Integer>();
        int position = 1;
        while (number > 0) {
            if ((number & 1) == 1) {
                parts.add(position);
            }
            number >>= 1;
            position <<= 1;
        }
        return parts;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getCode() {
        return this.code;
    }
}

