/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.constant.enums;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.openoa.base.constant.enums.ProcessBusinessCallBackTypeEnum;
import org.openoa.base.interf.BusinessCallBackAdaptor;
import org.openoa.base.service.BusinessCallBackFace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum BusinessCallbackEnum {
    PROCESS_EVENT_CALLBACK(1, ProcessBusinessCallBackTypeEnum.class, "\u6d41\u7a0b\u7c7b\u56de\u8c03\u679a\u4e3e");

    private static final Logger log;
    private final Integer code;
    private final Class<? extends BusinessCallBackFace> clsz;
    private final String desc;

    private BusinessCallbackEnum(Integer code, Class<? extends BusinessCallBackFace> clsz, String desc) {
        this.code = code;
        this.clsz = clsz;
        this.desc = desc;
    }

    public static Map<BusinessCallbackEnum, List<BusinessCallBackAdaptor>> getAllAdaptorsByType() {
        HashMap<BusinessCallbackEnum, List<BusinessCallBackAdaptor>> allAdaptorsOfType = new HashMap<BusinessCallbackEnum, List<BusinessCallBackAdaptor>>();
        for (BusinessCallbackEnum businessCallbackEnum : BusinessCallbackEnum.values()) {
            Class<? extends BusinessCallBackFace> clsz = businessCallbackEnum.getClsz();
            BusinessCallBackFace businessCallBackFace = null;
            try {
                businessCallBackFace = clsz.getEnumConstants()[0];
                Set<Class<BusinessCallBackAdaptor>> allAdaptors = businessCallBackFace.getAllAdaptors();
                ArrayList<BusinessCallBackAdaptor> businessCallBackAdaptors = new ArrayList<BusinessCallBackAdaptor>();
                for (Class<BusinessCallBackAdaptor> adaptor : allAdaptors) {
                    BusinessCallBackAdaptor businessCallBackAdaptor = adaptor.newInstance();
                    businessCallBackAdaptors.add(businessCallBackAdaptor);
                }
                allAdaptorsOfType.put(businessCallbackEnum, businessCallBackAdaptors);
            }
            catch (Exception ex) {
                log.error("error occur while creating instance by reflection");
            }
        }
        return allAdaptorsOfType;
    }

    public Integer getCode() {
        return this.code;
    }

    public Class<? extends BusinessCallBackFace> getClsz() {
        return this.clsz;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        log = LoggerFactory.getLogger(BusinessCallbackEnum.class);
    }
}

