/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.constant.enums;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.exception.JiMuBizException;

public enum JudgeOperatorEnum {
    GTE(1, ">="),
    GT(2, ">"),
    LTE(3, "<="),
    LT(4, "<"),
    EQ(5, "="),
    GT1LT2(6, "first<a<second"),
    GTE1LT2(7, "first<=a<second"),
    GET1LE2(8, "first<a<=second"),
    GTE1LTE2(9, "first<=a<=second");

    private final Integer code;
    private final String symbol;

    private JudgeOperatorEnum(Integer code, String symbol) {
        this.code = code;
        this.symbol = symbol;
    }

    public static JudgeOperatorEnum getBySymbol(String symbol) {
        if (StringUtils.isBlank((CharSequence)symbol)) {
            return null;
        }
        for (JudgeOperatorEnum value : JudgeOperatorEnum.values()) {
            if (!value.getSymbol().equals(symbol.trim())) continue;
            return value;
        }
        return null;
    }

    public static JudgeOperatorEnum getByOpType(Integer opType) {
        for (JudgeOperatorEnum value : JudgeOperatorEnum.values()) {
            if (!value.code.equals(opType)) continue;
            return value;
        }
        throw new JiMuBizException("\u64cd\u4f5c\u7b26\u7c7b\u578b\u672a\u5b9a\u4e49");
    }

    public static List<Integer> binaryOperator() {
        return Lists.newArrayList((Object[])new Integer[]{6, 7, 8, 9});
    }

    public Integer getCode() {
        return this.code;
    }

    public String getSymbol() {
        return this.symbol;
    }
}

