/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.service;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import org.openoa.base.adp.OrderedBean;
import org.openoa.base.service.AntFlowOrderPostProcessor;
import org.openoa.base.service.AntFlowOrderPreProcessor;
import org.openoa.base.util.SpringBeanUtils;

public class ProcessorFactory {
    public static <TEntity> void executePostProcessors(TEntity entity) {
        ProcessorFactory.executePostProcessors(AntFlowOrderPostProcessor.class, entity);
    }

    public static <TProcessor extends AntFlowOrderPostProcessor<TEntity>, TEntity> void executePostProcessors(Class<TProcessor> processorClass, TEntity entity) {
        List<AntFlowOrderPostProcessor> orderedPostProcessors = ProcessorFactory.getOrderedPostProcessors(processorClass, entity.getClass());
        for (AntFlowOrderPostProcessor orderedPostProcessor : orderedPostProcessors) {
            orderedPostProcessor.postProcess(entity);
        }
    }

    public static <TEntity> void executePreReadProcessors(TEntity entity) {
        ProcessorFactory.executePreReadProcessors(AntFlowOrderPreProcessor.class, entity);
    }

    public static <TEntity> void executePreWriteProcessors(TEntity entity) {
        ProcessorFactory.executePreWriteProcessors(AntFlowOrderPreProcessor.class, entity);
    }

    public static <TProcessor extends AntFlowOrderPreProcessor<TEntity>, TEntity> void executePreWriteProcessors(Class<TProcessor> processorClass, TEntity entity) {
        List<AntFlowOrderPreProcessor> orderedPostProcessors = ProcessorFactory.getOrderedPostProcessors(processorClass, entity.getClass());
        for (AntFlowOrderPreProcessor orderedPostProcessor : orderedPostProcessors) {
            orderedPostProcessor.preWriteProcess(entity);
        }
    }

    public static <TProcessor extends AntFlowOrderPreProcessor<TEntity>, TEntity> void executePreReadProcessors(Class<TProcessor> processorClass, TEntity entity) {
        List<AntFlowOrderPreProcessor> orderedPostProcessors = ProcessorFactory.getOrderedPostProcessors(processorClass, entity.getClass());
        for (AntFlowOrderPreProcessor orderedPostProcessor : orderedPostProcessors) {
            orderedPostProcessor.preReadProcess(entity);
        }
    }

    private static <TProcessor extends OrderedBean, TEntity> List<TProcessor> getOrderedPostProcessors(Class<TProcessor> processorCls, Class<TEntity> cls) {
        List<OrderedBean> orderedBeans = SpringBeanUtils.getOrderedBeans(processorCls);
        ArrayList<OrderedBean> processorsOfType = new ArrayList<OrderedBean>();
        if (orderedBeans.size() == 1) {
            return orderedBeans;
        }
        for (OrderedBean bean : orderedBeans) {
            Type[] genericInterfaces;
            for (Type genericInterface : genericInterfaces = bean.getClass().getGenericInterfaces()) {
                Type[] actualTypeArguments;
                if (!(genericInterface instanceof ParameterizedType)) continue;
                ParameterizedType parameterizedType = (ParameterizedType)genericInterface;
                for (Type actualTypeArgument : actualTypeArguments = parameterizedType.getActualTypeArguments()) {
                    if (!cls.isAssignableFrom((Class)actualTypeArgument)) continue;
                    processorsOfType.add(bean);
                }
            }
        }
        return processorsOfType;
    }
}

