/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JimuJsonUtil {
    private static final Logger log = LoggerFactory.getLogger(JimuJsonUtil.class);
    private static final ObjectMapper mapper = new ObjectMapper();

    public static <T> String toJsonString(T value) {
        StringWriter sw = new StringWriter();
        try {
            JsonGenerator gen = new JsonFactory().createGenerator((Writer)sw);
            mapper.writeValue(gen, value);
            gen.close();
        }
        catch (IOException var5) {
            log.error(var5.getMessage(), (Object)("value=[" + value + "]"));
        }
        return sw.toString();
    }

    public static <T> T readAsEntity(String jsonString, Class<T> cls) throws Exception {
        Object t = mapper.readValue(jsonString, cls);
        return (T)t;
    }

    public static <T> List<T> readAsList(String json, Class<T> cls) throws Exception {
        List o = (List)JimuJsonUtil.readAsYourType(json, List.class, cls);
        return o;
    }

    public static Map<String, Long> readAsMapSL(String json) throws Exception {
        return JimuJsonUtil.readAsMap(json, String.class, Long.class);
    }

    public static Map<String, Integer> readAsMapSI(String json) throws Exception {
        return JimuJsonUtil.readAsMap(json, String.class, Integer.class);
    }

    public static Map<String, String> readAsMapSS(String json) throws Exception {
        return JimuJsonUtil.readAsMap(json, String.class, String.class);
    }

    public static <Tvalue> Map<String, Tvalue> readAsMapS(String json, Class<String> valueClass) throws Exception {
        return JimuJsonUtil.readAsMap(json, String.class, valueClass);
    }

    public static <TKey, Tvalue> Map<TKey, Tvalue> readAsMap(String json, Class<TKey> keyClass, Class<Tvalue> valueClass) throws Exception {
        HashMap map = (HashMap)JimuJsonUtil.readAsYourType(json, HashMap.class, keyClass, valueClass);
        return map;
    }

    private static Object readAsYourType(String json, Class<?> rawType, Class<?> ... classes) throws Exception {
        JavaType javaType = mapper.getTypeFactory().constructParametricType(rawType, (Class[])classes);
        Object o = mapper.readValue(json, javaType);
        return o;
    }

    public static <T> T readAsType(String json, TypeReference<T> typeReference) throws JsonProcessingException {
        return (T)mapper.readValue(json, typeReference);
    }

    static {
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
}

