/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import jodd.mail.Email;
import jodd.mail.EmailAttachment;
import jodd.mail.MailServer;
import jodd.mail.SendMailSession;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.openoa.base.vo.MailInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class MailUtils {
    private static final Logger log = LoggerFactory.getLogger(MailUtils.class);
    @Value(value="${message.email.password:none}")
    private String password;
    @Value(value="${message.email.account:none}")
    private String account;
    @Value(value="${message.email.host:none}")
    private String host;

    public void doSendMail(MailInfo mail) {
        this.sendMailMain(mail);
    }

    public void sendMail(MailInfo mail) {
        this.sendMailMain(mail);
    }

    private void sendMailMain(MailInfo mail) {
        SendMailSession session = this.createSendMailSession();
        Email email = this.createEmail(mail);
        session.open();
        session.sendMail(email);
        session.close();
    }

    public void doSendMailBath(List<MailInfo> mailInfos) {
        this.sendMailBathMain(mailInfos);
    }

    public void sendMailBath(List<MailInfo> mailInfos) {
        this.sendMailBathMain(mailInfos);
    }

    public void sendMailBathMain(List<MailInfo> mailInfos) {
        SendMailSession session = this.createSendMailSession();
        session.open();
        mailInfos.forEach(o -> {
            Email email = this.createEmail((MailInfo)o);
            session.sendMail(email);
        });
        session.close();
    }

    private SendMailSession createSendMailSession() {
        return MailServer.create().host(this.host).auth(this.account, this.password).buildSmtpMailServer().createSession();
    }

    private Email createEmail(MailInfo mail) {
        Integer titleLimit = 130;
        String title = mail.getTitle();
        if (title.length() >= titleLimit) {
            title = StringUtils.join((Object[])new String[]{title.substring(0, titleLimit), "..."});
        }
        Email email = (Email)((Email)Email.create().from(this.account)).subject(title);
        if (!StringUtils.isEmpty((CharSequence)mail.getReceiver())) {
            email.to(mail.getReceiver());
        }
        if (!ObjectUtils.isEmpty(mail.getReceivers())) {
            email.to(mail.getReceivers().toArray(new String[mail.getReceivers().size()]));
        }
        String content = Optional.ofNullable(mail.getContent()).orElse("");
        email.textMessage("");
        email.htmlMessage(content);
        if (!ObjectUtils.isEmpty((Object)mail.getCc())) {
            email.cc(mail.getCc());
        }
        if (mail.getFile() != null) {
            File file = mail.getFile();
            email.attachment(EmailAttachment.with().name(file.getName()).content(file));
        }
        if (mail.getFileInputStream() != null) {
            try {
                email.attachment(EmailAttachment.with().name(mail.getFileName()).content(mail.getFileInputStream(), null));
            }
            catch (IOException e) {
                log.error("\u90ae\u4ef6\u53d1\u9001-\u9644\u4ef6\u6d41\u5904\u7406\u5931\u8d25", (Throwable)e);
                return email;
            }
        }
        return email;
    }
}

