/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class ShortUUID {
    private static final char[] DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z'};

    static NumberFormatException forInputString(String s) {
        return new NumberFormatException("For input string: \"" + s + "\"");
    }

    private static String digits(long val, int digits, char[] digitsArr) {
        long hi = 1L << digits * 4;
        return Numbers.toString(hi | val & hi - 1L, digitsArr.length, digitsArr).substring(1);
    }

    public static String uuid() {
        return ShortUUID.uuid(DIGITS);
    }

    public static String uuid(char[] digits) {
        UUID uuid = UUID.randomUUID();
        StringBuilder sb = new StringBuilder();
        sb.append(ShortUUID.digits(uuid.getMostSignificantBits() >> 32, 8, digits));
        sb.append(ShortUUID.digits(uuid.getMostSignificantBits() >> 16, 4, digits));
        sb.append(ShortUUID.digits(uuid.getMostSignificantBits(), 4, digits));
        sb.append(ShortUUID.digits(uuid.getLeastSignificantBits() >> 48, 4, digits));
        sb.append(ShortUUID.digits(uuid.getLeastSignificantBits(), 12, digits));
        return sb.toString();
    }

    private static class Numbers {
        private static final Map<Character, Integer> DIGIT_MAP = new HashMap<Character, Integer>();
        static final int MIN_RADIX = 2;

        private Numbers() {
        }

        static String toString(long i, int radix, char[] digits) {
            boolean negative;
            if (radix < 2 || radix > digits.length) {
                radix = 10;
            }
            if (radix == 10) {
                return Long.toString(i);
            }
            int size = 65;
            int charPos = 64;
            char[] buf = new char[65];
            boolean bl = negative = i < 0L;
            if (!negative) {
                i = -i;
            }
            while (i <= (long)(-radix)) {
                buf[charPos--] = digits[(int)(-(i % (long)radix))];
                i /= (long)radix;
            }
            buf[charPos] = digits[(int)(-i)];
            if (negative) {
                buf[--charPos] = 45;
            }
            return new String(buf, charPos, 65 - charPos);
        }

        static {
            for (int i = 0; i < DIGITS.length; ++i) {
                DIGIT_MAP.put(Character.valueOf(DIGITS[i]), i);
            }
        }
    }
}

