/*
 * Decompiled with CFR 0.152.
 */
package org.openoa.base.util;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class SnowFlake {
    private static final long twepoch = 12888349746579L;
    private static final long workerIdBits = 5L;
    private static final long datacenterIdBits = 5L;
    private static final long sequenceBits = 12L;
    private static final long maxWorkerId = 31L;
    private static final long maxDatacenterId = 31L;
    private static final long workerIdShift = 12L;
    private static final long datacenterIdShift = 17L;
    private static final long timestampLeftShift = 22L;
    private static final long sequenceMask = 4095L;
    private static long workerId;
    private static long datacenterId;
    private static long sequence;
    private static long lastTimestamp;

    public static synchronized long nextId() {
        long timestamp = SnowFlake.timeGen();
        if (timestamp < lastTimestamp) {
            throw new RuntimeException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", lastTimestamp - timestamp));
        }
        if (lastTimestamp == timestamp) {
            if ((sequence = sequence + 1L & 0xFFFL) == 0L) {
                timestamp = SnowFlake.tilNextMillis(lastTimestamp);
            }
        } else {
            sequence = 0L;
        }
        lastTimestamp = timestamp;
        return timestamp - 12888349746579L << 22 | datacenterId << 17 | workerId << 12 | sequence;
    }

    private static long tilNextMillis(long lastTimestamp) {
        long timestamp = SnowFlake.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = SnowFlake.timeGen();
        }
        return timestamp;
    }

    private static long timeGen() {
        return System.currentTimeMillis();
    }

    private static long getWorkerId() {
        try {
            String podName = System.getenv("POD_NAME");
            if (podName != null) {
                return (long)Math.abs(podName.hashCode()) & 0x1FL;
            }
            InetAddress ip = InetAddress.getLocalHost();
            return (long)Math.abs(ip.hashCode()) & 0x1FL;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    private static long getDatacenterId() {
        try {
            Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
            StringBuilder sb = new StringBuilder();
            while (networkInterfaces.hasMoreElements()) {
                NetworkInterface ni = networkInterfaces.nextElement();
                byte[] mac = ni.getHardwareAddress();
                if (mac == null) continue;
                for (byte b : mac) {
                    sb.append(String.format("%02X", b));
                }
            }
            return (long)Math.abs(sb.toString().hashCode()) & 0x1FL;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0L;
        }
    }

    static {
        sequence = 0L;
        lastTimestamp = -1L;
        workerId = SnowFlake.getWorkerId();
        datacenterId = SnowFlake.getDatacenterId();
    }
}

