/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.constraint;

import io.github.nambach.excelutil.constraint.Constraint;
import io.github.nambach.excelutil.constraint.ConstraintProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class ConstraintHandler {
    private final Workbook workbook;
    private final Map<String, DataValidation> cache = new HashMap<String, DataValidation>();

    public ConstraintHandler(Workbook workbook) {
        this.workbook = workbook;
    }

    private String computeKey(Constraint constraint, Sheet sheet) {
        return String.format("%s:%s", this.workbook.getSheetIndex(sheet), constraint.getUuid());
    }

    private DataValidation getCache(Constraint constraint, Sheet sheet) {
        return this.cache.get(this.computeKey(constraint, sheet));
    }

    private void putCache(Constraint constraint, Sheet sheet, DataValidation validation) {
        this.cache.put(this.computeKey(constraint, sheet), validation);
    }

    public void applyConstraint(Constraint constraint, Cell cell) {
        if (constraint == null) {
            return;
        }
        Sheet sheet = cell.getSheet();
        DataValidation validation = this.getCache(constraint, sheet);
        if (validation != null) {
            validation.getRegions().addCellRangeAddress(cell.getRowIndex(), cell.getColumnIndex(), cell.getRowIndex(), cell.getColumnIndex());
            return;
        }
        constraint.getProperty(ConstraintProperty.Dropdown).getAny(ArrayList.class).ifPresent(values -> this.applyDropdown((Collection<?>)values, constraint, cell));
    }

    private void applyDropdown(Collection<?> values, Constraint constraint, Cell cell) {
        CellRangeAddressList addressList;
        String[] strings;
        DataValidationConstraint dvConstraint;
        Sheet sheet = cell.getSheet();
        DataValidationHelper helper = sheet.getDataValidationHelper();
        DataValidation validation = helper.createValidation(dvConstraint = helper.createExplicitListConstraint(strings = (String[])values.stream().map(Object::toString).toArray(String[]::new)), addressList = new CellRangeAddressList(cell.getRowIndex(), cell.getRowIndex(), cell.getColumnIndex(), cell.getColumnIndex()));
        if (validation instanceof XSSFDataValidation) {
            validation.setSuppressDropDownArrow(true);
            validation.setShowErrorBox(true);
        } else {
            validation.setSuppressDropDownArrow(false);
        }
        sheet.addValidationData(validation);
        this.putCache(constraint, sheet, validation);
    }
}

