/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.constraint.Constraint;
import io.github.nambach.excelutil.core.ColumnTemplate;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.util.ListUtil;
import io.github.nambach.excelutil.util.ReflectUtil;
import io.github.nambach.excelutil.util.TextUtil;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;

public class ColumnMapper<T> {
    private static final String FIELD_NAME_FIRST_MESSAGE = "Field name must be provided first";
    ColumnTemplate<?> fieldTemplate;
    private String fieldName;
    private String displayName;
    private Function<T, ?> mapper;
    private boolean mergeOnValue;
    private Function<T, ?> mergeOnId;
    private Style style;
    private Function<T, Style> conditionalStyle;
    private Constraint constraint;
    private Integer pxWidth;
    private boolean autoSize;

    ColumnMapper() {
    }

    public String getField() {
        return this.fieldName;
    }

    public String getTitle() {
        return this.displayName;
    }

    public ColumnMapper<T> field(String fieldName) {
        this.fieldName = fieldName;
        return this;
    }

    public ColumnMapper<T> title(String displayName) {
        this.displayName = displayName;
        return this;
    }

    public ColumnMapper<T> transform(Function<T, ?> mapper) {
        this.mapper = mapper;
        return this;
    }

    public ColumnMapper<T> mergeOnValue(boolean b) {
        this.mergeOnValue = b;
        return this;
    }

    public ColumnMapper<T> mergeOnId(Function<T, ?> idExtractor) {
        this.mergeOnId = idExtractor;
        return this;
    }

    public ColumnMapper<T> style(Style style) {
        this.style = style;
        return this;
    }

    public ColumnMapper<T> conditionalStyle(Function<T, Style> style) {
        this.conditionalStyle = style;
        return this;
    }

    public ColumnMapper<T> constraint(Constraint constraint) {
        this.constraint = constraint;
        return this;
    }

    public ColumnMapper<T> width(Integer pixels) {
        this.pxWidth = pixels;
        return this;
    }

    public ColumnMapper<T> autoSize(boolean b) {
        this.autoSize = b;
        return this;
    }

    public ColumnMapper<T> expandRows() {
        Objects.requireNonNull(this.fieldName, FIELD_NAME_FIRST_MESSAGE);
        ColumnTemplate<Object> template = new ColumnTemplate<Object>(Object.class);
        template.column(c -> c.title(TextUtil.splitCamelCase(this.fieldName)).transform(o -> o));
        this.fieldTemplate = template;
        return this;
    }

    public <F> ColumnMapper<T> expandRows(Class<F> fClass, String ... fields) {
        Objects.requireNonNull(this.fieldName, FIELD_NAME_FIRST_MESSAGE);
        ColumnTemplate<F> template = new ColumnTemplate<F>(fClass);
        template.includeFields(fields);
        this.fieldTemplate = template;
        return this;
    }

    public <F> ColumnMapper<T> expandRows(Class<F> fClass, UnaryOperator<ColumnTemplate<F>> builder) {
        Objects.requireNonNull(this.fieldName, FIELD_NAME_FIRST_MESSAGE);
        ColumnTemplate<F> template = new ColumnTemplate<F>(fClass);
        builder.apply(template);
        this.fieldTemplate = template;
        return this;
    }

    Object retrieveValue(T object) {
        try {
            return this.mapper.apply(object);
        }
        catch (Exception e) {
            return null;
        }
    }

    Style applyConditionalStyle(T object) {
        if (this.conditionalStyle == null) {
            return null;
        }
        return this.conditionalStyle.apply(object);
    }

    Object retrievePivotValueForMergeComparison(T object, Object cellValue) {
        Object id = ReflectUtil.safeApply(this.mergeOnId, object);
        if (id != null) {
            return id;
        }
        return cellValue;
    }

    boolean needMerged() {
        return this.mergeOnValue || this.mergeOnId != null;
    }

    boolean isListField() {
        return ListUtil.hasMember(this.fieldTemplate);
    }

    <R> ColumnMapper<R> compose(Function<R, T> selector) {
        ColumnMapper<T> result = new ColumnMapper<T>();
        super.copyConfig(this);
        result.mapper = this.mapper.compose(selector);
        result.mergeOnId = this.mergeOnId != null ? this.mergeOnId.compose(selector) : selector;
        if (this.conditionalStyle != null) {
            result.conditionalStyle = this.conditionalStyle.compose(selector);
        }
        return result;
    }

    private void copyConfig(ColumnMapper<?> other) {
        this.fieldName = other.fieldName;
        this.displayName = other.displayName;
        this.mergeOnValue = other.mergeOnValue;
        this.style = other.style;
        this.pxWidth = other.pxWidth;
        this.autoSize = other.autoSize;
    }

    ColumnTemplate<?> getFieldTemplate() {
        return this.fieldTemplate;
    }

    String getFieldName() {
        return this.fieldName;
    }

    String getDisplayName() {
        return this.displayName;
    }

    Function<T, ?> getMapper() {
        return this.mapper;
    }

    boolean isMergeOnValue() {
        return this.mergeOnValue;
    }

    Function<T, ?> getMergeOnId() {
        return this.mergeOnId;
    }

    Style getStyle() {
        return this.style;
    }

    Constraint getConstraint() {
        return this.constraint;
    }

    Integer getPxWidth() {
        return this.pxWidth;
    }

    boolean isAutoSize() {
        return this.autoSize;
    }

    void setFieldTemplate(ColumnTemplate<?> fieldTemplate) {
        this.fieldTemplate = fieldTemplate;
    }

    void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    void setMapper(Function<T, ?> mapper) {
        this.mapper = mapper;
    }

    void setMergeOnValue(boolean mergeOnValue) {
        this.mergeOnValue = mergeOnValue;
    }

    void setMergeOnId(Function<T, ?> mergeOnId) {
        this.mergeOnId = mergeOnId;
    }

    void setStyle(Style style) {
        this.style = style;
    }

    void setConditionalStyle(Function<T, Style> conditionalStyle) {
        this.conditionalStyle = conditionalStyle;
    }

    void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    void setPxWidth(Integer pxWidth) {
        this.pxWidth = pxWidth;
    }

    void setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
    }
}

