/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.constraint.Constraint;
import io.github.nambach.excelutil.core.BaseEditor;
import io.github.nambach.excelutil.core.BaseReader;
import io.github.nambach.excelutil.core.BaseWriter;
import io.github.nambach.excelutil.core.DataTemplate;
import io.github.nambach.excelutil.core.FreestyleWriter;
import io.github.nambach.excelutil.core.PointerNavigation;
import io.github.nambach.excelutil.core.ReaderConfig;
import io.github.nambach.excelutil.core.Result;
import io.github.nambach.excelutil.core.Template;
import io.github.nambach.excelutil.core.WriterCell;
import io.github.nambach.excelutil.core.WriterComment;
import io.github.nambach.excelutil.style.HSSFColorCache;
import io.github.nambach.excelutil.style.Style;
import io.github.nambach.excelutil.util.ListUtil;
import io.github.nambach.excelutil.util.PixelUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class Editor
implements BaseEditor,
FreestyleWriter<Editor>,
AutoCloseable,
Iterable<Sheet> {
    private static final Logger log = LogManager.getLogger(Editor.class);
    private final Workbook workbook;
    private final BaseWriter writer;
    private final BaseReader reader;
    private final PointerNavigation navigation = new PointerNavigation();
    private Sheet currentSheet;
    private Style tempStyle;
    private boolean isDebug;

    public Editor() {
        this(Editor.getWorkbookFromStream(null));
    }

    public Editor(InputStream stream) {
        this(Editor.getWorkbookFromStream(stream));
    }

    public Editor(Workbook workbook) {
        if (workbook == null) {
            workbook = new XSSFWorkbook();
        }
        this.workbook = workbook;
        this.writer = new BaseWriter(workbook);
        this.reader = new BaseReader();
        if (workbook.getNumberOfSheets() != 0) {
            int index = workbook.getActiveSheetIndex();
            this.currentSheet = workbook.getSheetAt(index);
        }
    }

    private static Workbook getWorkbookFromStream(InputStream stream) {
        if (stream != null) {
            return WorkbookFactory.create((InputStream)stream);
        }
        return new XSSFWorkbook();
    }

    private Sheet getSheet() {
        if (this.currentSheet == null) {
            this.goToSheet(0);
        }
        return this.currentSheet;
    }

    @Override
    public void close() {
        this.workbook.close();
    }

    public Workbook getPoiWorkbook() {
        return this.workbook;
    }

    public Sheet getCurrentPoiSheet() {
        return this.currentSheet;
    }

    public Cell getCurrentPoiCell() {
        if (this.currentSheet == null) {
            return null;
        }
        return this.getCellAt(this.currentSheet, this.navigation);
    }

    private int getNextRowIndex() {
        return this.getSheet().getLastRowNum() + 1;
    }

    public Editor goToSheet(int index) {
        if (this.workbook.getNumberOfSheets() == 0) {
            this.goToSheet("Sheet1");
            return this;
        }
        this.currentSheet = index < 0 ? this.workbook.getSheetAt(0) : (index + 1 > this.workbook.getNumberOfSheets() ? this.workbook.getSheetAt(this.workbook.getNumberOfSheets() - 1) : this.workbook.getSheetAt(index));
        this.resetPointer();
        return this;
    }

    public Editor goToSheet(String sheetName) {
        this.currentSheet = this.workbook.getSheet(sheetName) != null ? this.workbook.getSheet(sheetName) : this.workbook.createSheet(sheetName);
        this.resetPointer();
        return this;
    }

    public String getSheetName() {
        return this.currentSheet == null ? null : this.currentSheet.getSheetName();
    }

    public Editor setSheetName(String sheetName) {
        int index = this.workbook.getSheetIndex(this.getSheet());
        this.workbook.setSheetName(index, sheetName);
        return this;
    }

    public int getTotalSheets() {
        return this.workbook.getNumberOfSheets();
    }

    @Override
    public Iterator<Sheet> iterator() {
        return new Iterator<Sheet>(){

            @Override
            public boolean hasNext() {
                return Editor.this.workbook.iterator().hasNext();
            }

            @Override
            public Sheet next() {
                Editor.this.currentSheet = (Sheet)Editor.this.workbook.iterator().next();
                return Editor.this.currentSheet;
            }
        };
    }

    private void resetPointer() {
        this.goToCell(0, 0);
    }

    @Override
    public Editor goToCell(String address) {
        this.navigation.goToCell(address);
        return this;
    }

    @Override
    public Editor goToCell(int row, int col) {
        this.navigation.goToCell(row, col);
        return this;
    }

    @Override
    public Editor next() {
        this.navigation.next();
        return this;
    }

    @Override
    public Editor next(int steps) {
        this.navigation.next(steps);
        return this;
    }

    @Override
    public Editor down() {
        this.navigation.down();
        return this;
    }

    @Override
    public Editor down(int steps) {
        this.navigation.down(steps);
        return this;
    }

    @Override
    public Editor enter() {
        this.navigation.update(this.getNextRowIndex(), 0);
        return this;
    }

    @Override
    public Editor enter(int steps) {
        if (steps > 0) {
            this.enter();
            this.navigation.down(steps - 1);
        }
        return this;
    }

    private void replaceStyle(CellAddress cellAddress, Style style) {
        Row row = this.getRowAt(this.getSheet(), cellAddress.getRow());
        Cell cell = this.getCellAt(row, cellAddress.getColumn());
        cell.setCellStyle(this.writer.cachedStyles.accumulate(style));
    }

    @Override
    public Editor useStyle(Style style) {
        this.tempStyle = style;
        return this;
    }

    @Override
    public Editor applyStyle() {
        if (this.tempStyle != null) {
            this.replaceStyle(this.navigation.getCellAddress(), this.tempStyle);
        }
        return this;
    }

    @Override
    public Editor applyStyle(Style style, String ... address) {
        if (style != null && (address == null || address.length == 0)) {
            this.replaceStyle(this.navigation.getCellAddress(), style);
        } else {
            this.applyStyle(style, Arrays.asList(address));
        }
        return this;
    }

    @Override
    public Editor applyStyle(Style style, Collection<String> addresses) {
        Sheet sheet = this.getSheet();
        if (style != null) {
            Collection<CellAddress> cellAddresses = this.parseAddress(addresses);
            Map<Integer, List<CellAddress>> rowMap = ListUtil.groupBy(cellAddresses, CellAddress::getRow);
            rowMap.forEach((? super K rowNum, ? super V cols) -> {
                Row row = this.getRowAt(sheet, (int)rowNum);
                for (CellAddress col : cols) {
                    Cell cell = this.getCellAt(row, col.getColumn());
                    cell.setCellStyle(this.writer.cachedStyles.accumulate(style));
                }
            });
        }
        return this;
    }

    @Override
    public Editor applyConstraint(Constraint constraint, String ... address) {
        if (address == null || address.length == 0) {
            Cell cell = this.getCellAt(this.getSheet(), this.navigation);
            this.writer.constraintHandler.applyConstraint(constraint, cell);
        } else {
            this.applyConstraint(constraint, Arrays.asList(address));
        }
        return this;
    }

    @Override
    public Editor applyConstraint(Constraint constraint, Collection<String> addresses) {
        Collection<CellAddress> cellAddresses = this.parseAddress(addresses);
        Map<Integer, List<CellAddress>> rowMap = ListUtil.groupBy(cellAddresses, CellAddress::getRow);
        Sheet sheet = this.getSheet();
        rowMap.forEach((? super K rowNum, ? super V cols) -> {
            Row row = this.getRowAt(sheet, (int)rowNum);
            for (CellAddress col : cols) {
                Cell cell = this.getCellAt(row, col.getColumn());
                this.writer.constraintHandler.applyConstraint(constraint, cell);
            }
        });
        return this;
    }

    @Override
    public Editor writeComment(UnaryOperator<WriterComment> builder) {
        Cell cell = this.getCellAt(this.getSheet(), this.navigation);
        this.writer.writeComment((WriterComment)builder.apply(new WriterComment()), cell);
        return this;
    }

    @Override
    public Editor writeCell(UnaryOperator<WriterCell> f) {
        WriterCell writerCell = (WriterCell)f.apply(new WriterCell(this.navigation.getCellAddress(), this.tempStyle));
        Cell cell = this.getCellAt(this.getSheet(), this.navigation);
        this.writer.writeCellInfo(writerCell, cell);
        this.navigation.updatePivotRight(writerCell.getColSpan() - 1);
        this.navigation.updatePivotDown(writerCell.getRowSpan() - 1);
        return this;
    }

    public Editor writeTemplate(Template template) {
        this.writer.writeTemplate(this.getSheet(), template);
        int[] rowIndex = template.getRowIndexRange();
        int[] colIndex = template.getColIndexRange();
        this.navigation.update(rowIndex[0], colIndex[0]);
        this.navigation.updatePivot(rowIndex[1], colIndex[1]);
        return this;
    }

    public <T> Editor writeData(DataTemplate<T> template, Collection<T> data) {
        if (data == null) {
            data = Collections.emptyList();
        }
        this.writer.writeData(this.getSheet(), template, data, this.navigation.getRow(), this.navigation.getCol());
        this.navigation.updatePivotRight(template.size() - 1);
        int headerRows = template.isNoHeader() ? 0 : 1;
        this.navigation.updatePivotDown(data.size() - 1 + headerRows);
        return this;
    }

    public ByteArrayInputStream exportToFile() {
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            this.workbook.write((OutputStream)out);
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            out.close();
            log.info("Excel file was successfully saved.");
            if (this.isDebug) {
                log.info(this.writer.cachedStyles.printTotalStyle());
            }
            return in;
        }
        catch (Exception e) {
            log.error("There some error writing excel file.", (Throwable)e);
            return null;
        }
    }

    public String readString() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readString();
    }

    public Date readDate() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readDate();
    }

    public LocalDateTime readLocalDateTime() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readLocalDateTime();
    }

    public Double readDouble() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readDouble();
    }

    public Float readFloat() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readFloat();
    }

    public Long readLong() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readLong();
    }

    public Integer readInt() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readInt();
    }

    public Boolean readBoolean() {
        return this.getReaderCellAt(this.getSheet(), this.navigation).readBoolean();
    }

    public <T> Result<T> readSection(ReaderConfig<T> config) {
        return this.reader.readSheet(this.getSheet(), config, this.navigation.getRow(), this.navigation.getCol());
    }

    public Editor configWorkbook(UnaryOperator<WorkbookConfig> f) {
        f.apply(new WorkbookConfig(this));
        return this;
    }

    public Editor configSheet(UnaryOperator<SheetConfig> f) {
        f.apply(new SheetConfig(this));
        return this;
    }

    public static class SheetConfig {
        private final Editor editor;

        public SheetConfig(Editor editor) {
            this.editor = editor;
        }

        public SheetConfig freeze(int rows, int cols) {
            if (rows < 0) {
                rows = 0;
            }
            if (cols < 0) {
                cols = 0;
            }
            this.editor.getSheet().createFreezePane(cols, rows);
            return this;
        }

        public SheetConfig setColumnWidth(int pixels, int ... colIndexes) {
            if (colIndexes == null) {
                return this;
            }
            Sheet sheet = this.editor.getSheet();
            for (int colIndex : colIndexes) {
                if (colIndex < 0) continue;
                PixelUtil.setColumnWidth(sheet, colIndex, pixels);
            }
            return this;
        }

        public SheetConfig autoSizeColumn(int ... colIndexes) {
            if (colIndexes == null) {
                return this;
            }
            Sheet sheet = this.editor.getSheet();
            for (int colIndex : colIndexes) {
                if (colIndex < 0) continue;
                sheet.autoSizeColumn(colIndex);
            }
            return this;
        }

        public SheetConfig setRowHeightInPoints(int height, int ... rowIndexes) {
            if (rowIndexes == null) {
                return this;
            }
            Sheet sheet = this.editor.getSheet();
            for (int rowIndex : rowIndexes) {
                if (rowIndex < 0) continue;
                Row row = this.editor.getRowAt(sheet, rowIndex);
                row.setHeightInPoints((float)height);
            }
            return this;
        }

        public SheetConfig autoSizeRow(int ... rowIndexes) {
            if (rowIndexes == null) {
                return this;
            }
            Sheet sheet = this.editor.getSheet();
            for (int rowIndex : rowIndexes) {
                CellStyle style;
                if (rowIndex < 0) continue;
                Row row = this.editor.getRowAt(sheet, rowIndex);
                if (this.editor.workbook instanceof XSSFWorkbook) {
                    row.setHeight((short)-1);
                    continue;
                }
                if (!(this.editor.workbook instanceof HSSFWorkbook) || (style = row.getRowStyle()) == null) continue;
                style.setWrapText(true);
            }
            return this;
        }

        public SheetConfig hideGrid(boolean b) {
            this.editor.getSheet().setDisplayGridlines(!b);
            return this;
        }

        public SheetConfig setZoom(int percentage) {
            this.editor.getSheet().setZoom(percentage);
            return this;
        }

        public SheetConfig debug(boolean b) {
            this.editor.isDebug = b;
            return this;
        }
    }

    public static class WorkbookConfig {
        private final Editor editor;

        public WorkbookConfig(Editor editor) {
            this.editor = editor;
        }

        public WorkbookConfig setXLSColorPolicy(HSSFColorCache.Policy policy) {
            ((Editor)this.editor).writer.cachedStyles.setHSSFColorPolicy(policy);
            return this;
        }
    }
}

