/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.constraint.Constraint;
import io.github.nambach.excelutil.core.Navigation;
import io.github.nambach.excelutil.core.WriterCell;
import io.github.nambach.excelutil.core.WriterComment;
import io.github.nambach.excelutil.style.Style;
import java.util.Collection;
import java.util.Date;
import java.util.function.UnaryOperator;

interface FreestyleWriter<T extends FreestyleWriter<T>>
extends Navigation<T> {
    public T useStyle(Style var1);

    public T applyStyle();

    public T applyStyle(Style var1, String ... var2);

    public T applyStyle(Style var1, Collection<String> var2);

    public T applyConstraint(Constraint var1, String ... var2);

    public T applyConstraint(Constraint var1, Collection<String> var2);

    public T writeComment(UnaryOperator<WriterComment> var1);

    default public T comment(String comment) {
        return this.writeComment(c -> c.content(comment));
    }

    public T writeCell(UnaryOperator<WriterCell> var1);

    default public T date(Date date) {
        return this.writeCell(c -> c.date(date));
    }

    default public T number(double number) {
        return this.writeCell(c -> c.number(number));
    }

    default public T text(String text) {
        return this.writeCell(c -> c.text(text));
    }
}

