/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import org.apache.poi.ss.util.CellAddress;

class Pointer {
    private int row;
    private int col;

    Pointer() {
    }

    public Pointer(int row, int col) {
        this.row = row;
        this.col = col;
    }

    public void sync(Pointer p) {
        this.row = p.row;
        this.col = p.col;
    }

    public void reset() {
        this.row = 0;
        this.col = 0;
    }

    public void update(String address) {
        CellAddress a = new CellAddress(address);
        this.update(a.getRow(), a.getColumn());
    }

    public void update(int row, int col) {
        if (row < 0 || col < 0) {
            throw new RuntimeException("Coordinate must be from 0.");
        }
        this.row = row;
        this.col = col;
    }

    public void moveRight() {
        ++this.col;
    }

    public void moveRight(int steps) {
        this.col += steps;
    }

    public void jumpRight(Pointer other) {
        int colGap = other.col - this.col;
        if (colGap < 0) {
            colGap = 0;
        }
        this.col += 1 + colGap;
    }

    public void moveDown() {
        ++this.row;
    }

    public void moveDown(int steps) {
        this.row += steps;
    }

    public void jumpDown(Pointer other) {
        int rowGap = other.row - this.row;
        if (rowGap < 0) {
            rowGap = 0;
        }
        this.row += 1 + rowGap;
    }

    public void enter() {
        ++this.row;
        this.col = 0;
    }

    public void enter(Pointer other) {
        this.jumpDown(other);
        this.col = 0;
    }

    public boolean same(Pointer other) {
        return this.row == other.row && this.col == other.col;
    }

    public int getRow() {
        return this.row;
    }

    public int getCol() {
        return this.col;
    }
}

