/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.Pointer;
import org.apache.poi.ss.util.CellAddress;

class PointerNavigation {
    private final Pointer pointer = new Pointer();
    private final Pointer pivot = new Pointer();

    PointerNavigation() {
    }

    public CellAddress getCellAddress() {
        return new CellAddress(this.pointer.getRow(), this.pointer.getCol());
    }

    public int getRow() {
        return this.pointer.getRow();
    }

    public int getCol() {
        return this.pointer.getCol();
    }

    public void goToCell(String address) {
        this.pointer.update(address);
        this.pivot.sync(this.pointer);
    }

    public void goToCell(int row, int col) {
        this.pointer.update(row, col);
        this.pivot.sync(this.pointer);
    }

    public void next() {
        this.pointer.jumpRight(this.pivot);
        this.pivot.sync(this.pointer);
    }

    public void next(int steps) {
        if (steps > 0) {
            this.next();
            this.pointer.moveRight(steps - 1);
            this.pivot.sync(this.pointer);
        }
    }

    public void down() {
        this.pointer.jumpDown(this.pivot);
        this.pivot.sync(this.pointer);
    }

    public void down(int steps) {
        if (steps > 0) {
            this.down();
            this.pointer.moveDown(steps - 1);
            this.pivot.sync(this.pointer);
        }
    }

    public void enter() {
        this.pointer.enter();
        this.pivot.sync(this.pointer);
    }

    public void enter(int steps) {
        if (steps > 0) {
            this.enter();
            this.pointer.moveDown(steps - 1);
            this.pivot.sync(this.pointer);
        }
    }

    public void update(int row, int col) {
        this.pointer.update(row, col);
        this.pivot.sync(this.pointer);
    }

    public void updatePivot(int row, int col) {
        this.pivot.update(row, col);
    }

    public void updatePivotRight(int steps) {
        this.pivot.moveRight(steps);
    }

    public void updatePivotDown(int steps) {
        this.pivot.moveDown(steps);
    }

    public void sync(PointerNavigation other) {
        this.pointer.sync(other.pointer);
        this.pivot.sync(other.pivot);
    }
}

