/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.Editor;
import io.github.nambach.excelutil.core.Handler;
import io.github.nambach.excelutil.core.HandlerMap;
import io.github.nambach.excelutil.core.Pointer;
import io.github.nambach.excelutil.core.ReaderRow;
import io.github.nambach.excelutil.core.Result;
import io.github.nambach.excelutil.util.ReflectUtil;
import io.github.nambach.excelutil.validator.Validator;
import io.github.nambach.excelutil.validator.builtin.TypeValidator;
import java.beans.PropertyDescriptor;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;

public class ReaderConfig<T> {
    private Class<T> tClass;
    private int titleRowIndex = -1;
    private int dataFromIndex = -1;
    private boolean earlyExit;
    private Validator<T> validator;
    private HandlerMap<T> handlerMap = new HandlerMap();
    private BiConsumer<T, ReaderRow> beforeAddItemHandle;

    ReaderConfig(Class<T> tClass) {
        this.tClass = tClass;
    }

    public static <T> ReaderConfig<T> fromClass(Class<T> tClass) {
        return new ReaderConfig<T>(tClass);
    }

    private Pointer getBaseCoordinate() {
        int baseRow = this.titleRowIndex >= 0 ? this.titleRowIndex : this.dataFromIndex;
        int baseCol = this.handlerMap.getMinIndex();
        return new Pointer(baseRow, baseCol);
    }

    ReaderConfig<T> translate(int rowAt, int colAt) {
        Pointer base = this.getBaseCoordinate();
        int baseRow = base.getRow();
        int baseCol = base.getCol();
        int rowOffset = rowAt - baseRow;
        int colOffset = colAt - baseCol;
        if (rowOffset == 0 && colOffset == 0) {
            return this;
        }
        ReaderConfig<T> copy = new ReaderConfig<T>(this.tClass);
        if (this.titleRowIndex >= 0) {
            copy.titleRowIndex = this.titleRowIndex + rowOffset;
        }
        if (this.dataFromIndex >= 0) {
            copy.dataFromIndex = this.dataFromIndex + rowOffset;
        }
        copy.handlerMap = this.handlerMap.makeCopy();
        copy.handlerMap.shiftIndexMap(colOffset);
        copy.earlyExit = this.earlyExit;
        copy.beforeAddItemHandle = this.beforeAddItemHandle;
        copy.validator = this.validator;
        return copy;
    }

    public ReaderConfig<T> titleAtRow(int index) {
        this.titleRowIndex = index;
        return this;
    }

    public ReaderConfig<T> dataFromRow(int index) {
        this.dataFromIndex = index;
        return this;
    }

    public ReaderConfig<T> exitWhenValidationFailed(boolean b) {
        this.earlyExit = b;
        return this;
    }

    public ReaderConfig<T> column(int index, String fieldName) {
        TypeValidator nullValidator = null;
        return this.column(index, fieldName, nullValidator);
    }

    public ReaderConfig<T> column(int index, String fieldName, UnaryOperator<TypeValidator> builder) {
        TypeValidator typeValidator = (TypeValidator)builder.apply(TypeValidator.init());
        return this.column(index, fieldName, typeValidator);
    }

    public ReaderConfig<T> column(int index, String fieldName, TypeValidator typeValidator) {
        PropertyDescriptor pd = ReflectUtil.getField(fieldName, this.tClass);
        if (index >= 0 && pd != null) {
            Handler handler = new Handler().atColumn(index).field(fieldName).wrapHandleField(pd).validate(typeValidator);
            this.handlerMap.putAt(index, handler);
        }
        return this;
    }

    public ReaderConfig<T> column(String title, String fieldName) {
        TypeValidator nullValidator = null;
        return this.column(title, fieldName, nullValidator);
    }

    public ReaderConfig<T> column(String title, String fieldName, UnaryOperator<TypeValidator> builder) {
        TypeValidator typeValidator = (TypeValidator)builder.apply(TypeValidator.init());
        return this.column(title, fieldName, typeValidator);
    }

    public ReaderConfig<T> column(String title, String fieldName, TypeValidator typeValidator) {
        PropertyDescriptor pd = ReflectUtil.getField(fieldName, this.tClass);
        if (title != null && pd != null) {
            if (this.titleRowIndex < 0) {
                throw new RuntimeException("Index of title row must be provided through .titleAtRow(int); 'index=" + this.titleRowIndex + "' found instead.");
            }
            Handler handler = new Handler().atColumn(title).field(fieldName).wrapHandleField(pd).validate(typeValidator);
            this.handlerMap.put(title, handler);
        }
        return this;
    }

    public ReaderConfig<T> handler(UnaryOperator<Handler<T>> func) {
        Handler handler = new Handler();
        func.apply(handler);
        Integer indexAt = handler.getColAt();
        Integer indexFrom = handler.getColFrom();
        String title = handler.getColTitle();
        if (indexAt == null && indexFrom == null && title == null) {
            throw new RuntimeException("Handler must have a column index with .atColumn(int) or .fromColumn(int), or a column title with .atColumn(String)");
        }
        if (indexAt != null) {
            this.handlerMap.putAt(indexAt, handler);
        } else if (indexFrom != null) {
            this.handlerMap.putFrom(indexFrom, handler);
        } else {
            if (this.titleRowIndex < 0) {
                throw new RuntimeException("Index of title row must be provided via .titleAtRow(int)");
            }
            this.handlerMap.put(title, handler);
        }
        return this;
    }

    public ReaderConfig<T> beforeAddingItem(BiConsumer<T, ReaderRow> handler) {
        this.beforeAddItemHandle = ReflectUtil.safeWrap(handler);
        return this;
    }

    public ReaderConfig<T> validator(Validator<T> validator) {
        this.validator = validator;
        return this;
    }

    void handleBeforeAdd(T object, ReaderRow readerRow) {
        if (this.beforeAddItemHandle != null) {
            this.beforeAddItemHandle.accept(object, readerRow);
        }
    }

    public Result<T> readSheet(InputStream stream, int sheetIndex) {
        Pointer base = this.getBaseCoordinate();
        try (Editor editor = new Editor(stream);){
            Result result = editor.goToSheet(sheetIndex).goToCell(base.getRow(), base.getCol()).readSection(this);
            return result;
        }
    }

    public Result<T> readSheet(InputStream stream) {
        return this.readSheet(stream, 0);
    }

    public List<T> readSheet(InputStream stream, String sheetName) {
        Pointer base = this.getBaseCoordinate();
        try (Editor editor = new Editor(stream);){
            int index = editor.getPoiWorkbook().getSheetIndex(sheetName);
            Result result = editor.goToSheet(index).goToCell(base.getRow(), base.getCol()).readSection(this);
            return result;
        }
    }

    public Map<String, Result<T>> readSheets(InputStream stream, int ... sheetIndexes) {
        Objects.requireNonNull(sheetIndexes);
        HashSet<Integer> indexes = new HashSet<Integer>();
        for (int sheetIndex : sheetIndexes) {
            indexes.add(sheetIndex);
        }
        Pointer base = this.getBaseCoordinate();
        try (Editor editor = new Editor(stream);){
            LinkedHashMap<String, Result<T>> result = new LinkedHashMap<String, Result<T>>();
            for (int i = 0; i < editor.getTotalSheets(); ++i) {
                if (!indexes.contains(i)) continue;
                Result list = editor.goToSheet(i).goToCell(base.getRow(), base.getCol()).readSection(this);
                result.put(editor.getSheetName(), list);
            }
            LinkedHashMap<String, Result<T>> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    public Map<String, Result<T>> readSheets(InputStream stream, String ... sheetNames) {
        Objects.requireNonNull(sheetNames);
        HashSet<String> names = new HashSet<String>(Arrays.asList(sheetNames));
        Pointer base = this.getBaseCoordinate();
        try (Editor editor = new Editor(stream);){
            LinkedHashMap result = new LinkedHashMap();
            for (String name : names) {
                int i = editor.getPoiWorkbook().getSheetIndex(name);
                if (i < 0) continue;
                Result list = editor.goToSheet(i).goToCell(base.getRow(), base.getCol()).readSection(this);
                result.put(editor.getSheetName(), list);
            }
            LinkedHashMap linkedHashMap = result;
            return linkedHashMap;
        }
    }

    public Map<String, Result<T>> readAllSheets(InputStream stream) {
        Pointer base = this.getBaseCoordinate();
        try (Editor editor = new Editor(stream);){
            LinkedHashMap<String, Result<T>> result = new LinkedHashMap<String, Result<T>>();
            for (int i = 0; i < editor.getTotalSheets(); ++i) {
                Result list = editor.goToSheet(i).goToCell(base.getRow(), base.getCol()).readSection(this);
                result.put(editor.getSheetName(), list);
            }
            LinkedHashMap<String, Result<T>> linkedHashMap = result;
            return linkedHashMap;
        }
    }

    Class<T> getTClass() {
        return this.tClass;
    }

    int getTitleRowIndex() {
        return this.titleRowIndex;
    }

    int getDataFromIndex() {
        return this.dataFromIndex;
    }

    boolean isEarlyExit() {
        return this.earlyExit;
    }

    Validator<T> getValidator() {
        return this.validator;
    }

    HandlerMap<T> getHandlerMap() {
        return this.handlerMap;
    }

    BiConsumer<T, ReaderRow> getBeforeAddItemHandle() {
        return this.beforeAddItemHandle;
    }

    void setTClass(Class<T> tClass) {
        this.tClass = tClass;
    }

    void setTitleRowIndex(int titleRowIndex) {
        this.titleRowIndex = titleRowIndex;
    }

    void setDataFromIndex(int dataFromIndex) {
        this.dataFromIndex = dataFromIndex;
    }

    void setEarlyExit(boolean earlyExit) {
        this.earlyExit = earlyExit;
    }

    void setValidator(Validator<T> validator) {
        this.validator = validator;
    }

    void setHandlerMap(HandlerMap<T> handlerMap) {
        this.handlerMap = handlerMap;
    }

    void setBeforeAddItemHandle(BiConsumer<T, ReaderRow> beforeAddItemHandle) {
        this.beforeAddItemHandle = beforeAddItemHandle;
    }
}

