/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.core.Raw;
import io.github.nambach.excelutil.core.RowError;
import io.github.nambach.excelutil.util.ListUtil;
import java.util.ArrayList;
import java.util.List;

public class Result<T>
extends ArrayList<T>
implements List<T> {
    private final Class<T> tClass;
    private final List<Raw<T>> rawData = new ArrayList<Raw<T>>();
    private final List<RowError> errors = new ArrayList<RowError>();

    public Result(Class<T> tClass) {
        this.tClass = tClass;
    }

    public boolean hasErrors() {
        return ListUtil.hasMember(this.errors);
    }

    public boolean noError() {
        return ListUtil.isNullOrEmpty(this.errors);
    }

    void addRaw(Raw<T> raw) {
        this.rawData.add(raw);
        this.add(raw.getData());
    }

    RowError newRowError(int index) {
        return ListUtil.findElse(this.errors, l -> l.getIndex() == index, new RowError(index, this.tClass));
    }

    public List<Raw<T>> getRawData() {
        return this.rawData;
    }

    public List<RowError> getErrors() {
        return this.errors;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Result)) {
            return false;
        }
        Result other = (Result)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Class<T> this$tClass = this.tClass;
        Class<T> other$tClass = other.tClass;
        if (this$tClass == null ? other$tClass != null : !this$tClass.equals(other$tClass)) {
            return false;
        }
        List<Raw<T>> this$rawData = this.getRawData();
        List<Raw<T>> other$rawData = other.getRawData();
        if (this$rawData == null ? other$rawData != null : !((Object)this$rawData).equals(other$rawData)) {
            return false;
        }
        List<RowError> this$errors = this.getErrors();
        List<RowError> other$errors = other.getErrors();
        return !(this$errors == null ? other$errors != null : !((Object)this$errors).equals(other$errors));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Result;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Class<T> $tClass = this.tClass;
        result = result * 59 + ($tClass == null ? 43 : $tClass.hashCode());
        List<Raw<T>> $rawData = this.getRawData();
        result = result * 59 + ($rawData == null ? 43 : ((Object)$rawData).hashCode());
        List<RowError> $errors = this.getErrors();
        result = result * 59 + ($errors == null ? 43 : ((Object)$errors).hashCode());
        return result;
    }
}

