/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.core;

import io.github.nambach.excelutil.constraint.Constraint;
import io.github.nambach.excelutil.core.WriterComment;
import io.github.nambach.excelutil.style.Style;
import java.util.Date;
import java.util.function.UnaryOperator;
import org.apache.poi.ss.util.CellAddress;

public class WriterCell {
    private String content;
    private Double value;
    private Date date;
    private int rowAt;
    private int colAt;
    private int rowSpan = 1;
    private int colSpan = 1;
    private Style style;
    private Constraint constraint;
    private WriterComment comment;

    WriterCell(CellAddress address, Style style) {
        this.rowAt = address.getRow();
        this.colAt = address.getColumn();
        this.style = style;
    }

    public WriterCell text(String s) {
        this.content = s;
        return this;
    }

    public WriterCell number(double v) {
        this.value = v;
        return this;
    }

    public WriterCell date(Date d) {
        this.date = d;
        return this;
    }

    public WriterCell date(Date d, String datePattern) {
        this.date = d;
        if (datePattern != null) {
            this.style(s -> s.datePattern(datePattern));
        }
        return this;
    }

    public WriterCell colSpan(int v) {
        if (v > 1) {
            this.colSpan = v;
        }
        return this;
    }

    public WriterCell rowSpan(int v) {
        if (v > 1) {
            this.rowSpan = v;
        }
        return this;
    }

    public WriterCell comment(String comment) {
        return this.comment(c -> c.content(comment));
    }

    public WriterCell comment(String comment, String author) {
        return this.comment(c -> c.content(comment).author(author));
    }

    public WriterCell comment(UnaryOperator<WriterComment> builder) {
        this.comment = (WriterComment)builder.apply(new WriterComment());
        return this;
    }

    public WriterCell replaceStyle(Style style) {
        this.style = style;
        return this;
    }

    public WriterCell style(UnaryOperator<Style.StyleBuilder> f) {
        if (f != null) {
            Style.StyleBuilder builder = Style.builder(this.style);
            f.apply(builder);
            this.style = builder.build();
        }
        return this;
    }

    public WriterCell constraint(Constraint constraint) {
        this.constraint = constraint;
        return this;
    }

    String getContent() {
        return this.content;
    }

    Double getValue() {
        return this.value;
    }

    Date getDate() {
        return this.date;
    }

    int getRowAt() {
        return this.rowAt;
    }

    int getColAt() {
        return this.colAt;
    }

    int getRowSpan() {
        return this.rowSpan;
    }

    int getColSpan() {
        return this.colSpan;
    }

    Style getStyle() {
        return this.style;
    }

    Constraint getConstraint() {
        return this.constraint;
    }

    WriterComment getComment() {
        return this.comment;
    }

    void setContent(String content) {
        this.content = content;
    }

    void setValue(Double value) {
        this.value = value;
    }

    void setDate(Date date) {
        this.date = date;
    }

    void setRowAt(int rowAt) {
        this.rowAt = rowAt;
    }

    void setColAt(int colAt) {
        this.colAt = colAt;
    }

    void setRowSpan(int rowSpan) {
        this.rowSpan = rowSpan;
    }

    void setColSpan(int colSpan) {
        this.colSpan = colSpan;
    }

    void setStyle(Style style) {
        this.style = style;
    }

    void setConstraint(Constraint constraint) {
        this.constraint = constraint;
    }

    void setComment(WriterComment comment) {
        this.comment = comment;
    }
}

