/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.util.IOUtils;

public class FileUtil {
    private static final Logger log = LogManager.getLogger(FileUtil.class);

    private FileUtil() {
    }

    public static void writeToDisk(String path, InputStream inputStream, boolean closeQuietly) {
        File targetFile = new File(path);
        try {
            Files.copy(inputStream, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            log.error("Some error happened while writing file to disk.", (Throwable)e);
        }
        if (closeQuietly) {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
    }

    public static InputStream readFromDisk(String path) throws FileNotFoundException {
        return new FileInputStream(path);
    }
}

