/*
 * Decompiled with CFR 0.152.
 */
package io.github.nambach.excelutil.validator.builtin;

import io.github.nambach.excelutil.validator.Constraint;
import io.github.nambach.excelutil.validator.builtin.StringConstraint;
import io.github.nambach.excelutil.validator.builtin.TypeValidator;

public class StringValidator
extends TypeValidator {
    StringValidator() {
        Constraint.Set temp = new Constraint.Set();
        temp.add(StringConstraint.IsString);
        temp.addAll(this.constraints);
        this.constraints = temp;
    }

    @Override
    public StringValidator notNull() {
        super.notNull();
        return this;
    }

    @Override
    public StringValidator notNull(String message) {
        super.notNull(message);
        return this;
    }

    public StringValidator notEmpty() {
        this.constraints.add(StringConstraint.NotEmpty);
        return this;
    }

    public StringValidator notEmpty(String message) {
        this.constraints.add(StringConstraint.NotEmpty.withMessage(message));
        return this;
    }

    public StringValidator notBlank() {
        this.constraints.add(StringConstraint.NotBlank);
        return this;
    }

    public StringValidator notBlank(String message) {
        this.constraints.add(StringConstraint.NotBlank.withMessage(message));
        return this;
    }

    public StringValidator isEmail() {
        this.constraints.add(StringConstraint.IsEmail);
        return this;
    }

    public StringValidator isEmail(String message) {
        this.constraints.add(StringConstraint.IsEmail.withMessage(message));
        return this;
    }

    public StringValidator minLength(long minLength) {
        this.constraints.add(StringConstraint.MinLength.apply(minLength));
        return this;
    }

    public StringValidator minLength(long minLength, String message) {
        this.constraints.add(StringConstraint.MinLength.apply(minLength).withMessage(message));
        return this;
    }

    public StringValidator maxLength(long maxLength) {
        this.constraints.add(StringConstraint.MaxLength.apply(maxLength));
        return this;
    }

    public StringValidator maxLength(long maxLength, String message) {
        this.constraints.add(StringConstraint.MaxLength.apply(maxLength).withMessage(message));
        return this;
    }

    public StringValidator lengthBetween(long min, long max) {
        this.constraints.add(StringConstraint.BoundLength.apply(min, max));
        return this;
    }

    public StringValidator lengthBetween(long min, long max, String message) {
        this.constraints.add(StringConstraint.BoundLength.apply(min, max).withMessage(message));
        return this;
    }
}

