/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.core.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionChoice;
import io.github.pigmesh.ai.deepseek.core.shared.Usage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class ChatCompletionResponse {
    @JsonProperty
    private final String id;
    @JsonProperty
    private final Integer created;
    @JsonProperty
    private final String model;
    @JsonProperty
    private final List<ChatCompletionChoice> choices;
    @JsonProperty
    private final Usage usage;
    @JsonProperty
    private final String systemFingerprint;
    @JsonProperty
    private final String serviceTier;

    private ChatCompletionResponse(Builder builder) {
        this.id = builder.id;
        this.created = builder.created;
        this.model = builder.model;
        this.choices = builder.choices;
        this.usage = builder.usage;
        this.systemFingerprint = builder.systemFingerprint;
        this.serviceTier = builder.serviceTier;
    }

    public String id() {
        return this.id;
    }

    public Integer created() {
        return this.created;
    }

    public String model() {
        return this.model;
    }

    public List<ChatCompletionChoice> choices() {
        return this.choices;
    }

    public Usage usage() {
        return this.usage;
    }

    public String systemFingerprint() {
        return this.systemFingerprint;
    }

    public String serviceTier() {
        return this.serviceTier;
    }

    public String content() {
        return this.choices().get(0).message().content();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ChatCompletionResponse && this.equalTo((ChatCompletionResponse)another);
    }

    private boolean equalTo(ChatCompletionResponse another) {
        return Objects.equals(this.id, another.id) && Objects.equals(this.created, another.created) && Objects.equals(this.model, another.model) && Objects.equals(this.choices, another.choices) && Objects.equals(this.usage, another.usage) && Objects.equals(this.systemFingerprint, another.systemFingerprint) && Objects.equals(this.serviceTier, another.serviceTier);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.created);
        h += (h << 5) + Objects.hashCode(this.model);
        h += (h << 5) + Objects.hashCode(this.choices);
        h += (h << 5) + Objects.hashCode(this.usage);
        h += (h << 5) + Objects.hashCode(this.systemFingerprint);
        h += (h << 5) + Objects.hashCode(this.serviceTier);
        return h;
    }

    public String toString() {
        return "ChatCompletionResponse{id=" + this.id + ", created=" + this.created + ", model=" + this.model + ", choices=" + this.choices + ", usage=" + this.usage + ", systemFingerprint=" + this.systemFingerprint + ", serviceTier=" + this.serviceTier + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String id;
        private Integer created;
        private String model;
        private List<ChatCompletionChoice> choices;
        private Usage usage;
        private String systemFingerprint;
        private String serviceTier;

        private Builder() {
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder created(Integer created) {
            this.created = created;
            return this;
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder choices(List<ChatCompletionChoice> choices) {
            if (choices != null) {
                this.choices = Collections.unmodifiableList(choices);
            }
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public Builder systemFingerprint(String systemFingerprint) {
            this.systemFingerprint = systemFingerprint;
            return this;
        }

        public Builder serviceTier(String serviceTier) {
            this.serviceTier = serviceTier;
            return this;
        }

        public ChatCompletionResponse build() {
            return new ChatCompletionResponse(this);
        }
    }
}

