/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.pigmesh.ai.deepseek.core.ApiKeyHeaderInjector;
import io.github.pigmesh.ai.deepseek.core.AuthorizationHeaderInjector;
import io.github.pigmesh.ai.deepseek.core.GenericHeaderInjector;
import io.github.pigmesh.ai.deepseek.core.Json;
import io.github.pigmesh.ai.deepseek.core.OpenAiApi;
import io.github.pigmesh.ai.deepseek.core.OpenAiClient;
import io.github.pigmesh.ai.deepseek.core.PersistorConverterFactory;
import io.github.pigmesh.ai.deepseek.core.RequestExecutor;
import io.github.pigmesh.ai.deepseek.core.RequestLoggingInterceptor;
import io.github.pigmesh.ai.deepseek.core.ResponseLoggingInterceptor;
import io.github.pigmesh.ai.deepseek.core.SyncOrAsync;
import io.github.pigmesh.ai.deepseek.core.SyncOrAsyncOrStreaming;
import io.github.pigmesh.ai.deepseek.core.SyncRequestExecutor;
import io.github.pigmesh.ai.deepseek.core.Utils;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionRequest;
import io.github.pigmesh.ai.deepseek.core.chat.ChatCompletionResponse;
import io.github.pigmesh.ai.deepseek.core.completion.CompletionRequest;
import io.github.pigmesh.ai.deepseek.core.completion.CompletionResponse;
import io.github.pigmesh.ai.deepseek.core.moderation.ModerationRequest;
import io.github.pigmesh.ai.deepseek.core.moderation.ModerationResponse;
import io.github.pigmesh.ai.deepseek.core.moderation.ModerationResult;
import io.github.pigmesh.ai.deepseek.core.search.SearchApi;
import io.github.pigmesh.ai.deepseek.core.search.SearchRequest;
import io.github.pigmesh.ai.deepseek.core.search.SearchResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Objects;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.core.publisher.Flux;
import reactor.core.publisher.FluxSink;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class DeepSeekClient
extends OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(DeepSeekClient.class);
    private final String baseUrl;
    private final String apiVersion;
    private final String model;
    private final OkHttpClient okHttpClient;
    private final OpenAiApi openAiApi;
    private final SearchApi searchApi;
    private final boolean logStreamingResponses;
    private final String systemMessage;

    public DeepSeekClient(String apiKey) {
        this((Builder)new Builder().openAiApiKey(apiKey));
    }

    public DeepSeekClient(Builder serviceBuilder) {
        this.baseUrl = serviceBuilder.baseUrl;
        this.apiVersion = serviceBuilder.apiVersion;
        this.model = serviceBuilder.model;
        this.systemMessage = serviceBuilder.systemMessage;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(serviceBuilder.callTimeout).connectTimeout(serviceBuilder.connectTimeout).readTimeout(serviceBuilder.readTimeout).writeTimeout(serviceBuilder.writeTimeout);
        if (serviceBuilder.dispatcher != null) {
            okHttpClientBuilder.dispatcher(serviceBuilder.dispatcher);
        }
        if (serviceBuilder.openAiApiKey == null && serviceBuilder.azureApiKey == null) {
            throw new IllegalArgumentException("openAiApiKey OR azureApiKey must be defined");
        }
        if (serviceBuilder.openAiApiKey != null && serviceBuilder.azureApiKey != null) {
            throw new IllegalArgumentException("openAiApiKey AND azureApiKey cannot both be defined at the same time");
        }
        if (serviceBuilder.openAiApiKey != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)new AuthorizationHeaderInjector(serviceBuilder.openAiApiKey));
        } else {
            okHttpClientBuilder.addInterceptor((Interceptor)new ApiKeyHeaderInjector(serviceBuilder.azureApiKey));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (serviceBuilder.organizationId != null) {
            headers.put("OpenAI-Organization", serviceBuilder.organizationId);
        }
        if (serviceBuilder.userAgent != null) {
            headers.put("User-Agent", serviceBuilder.userAgent);
        }
        if (serviceBuilder.customHeaders != null) {
            headers.putAll(serviceBuilder.customHeaders);
        }
        if (!headers.isEmpty()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new GenericHeaderInjector(headers));
        }
        if (serviceBuilder.proxy != null) {
            okHttpClientBuilder.proxy(serviceBuilder.proxy);
        }
        if (serviceBuilder.logRequests) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor(serviceBuilder.logLevel));
        }
        if (serviceBuilder.logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor(serviceBuilder.logLevel));
        }
        this.logStreamingResponses = serviceBuilder.logStreamingResponses;
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(serviceBuilder.baseUrl).client(this.okHttpClient);
        if (serviceBuilder.persistTo != null) {
            retrofitBuilder.addConverterFactory((Converter.Factory)new PersistorConverterFactory(serviceBuilder.persistTo));
        }
        retrofitBuilder.addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)Json.OBJECT_MAPPER));
        this.openAiApi = (OpenAiApi)retrofitBuilder.build().create(OpenAiApi.class);
        OkHttpClient searchOkHttpClient = new OkHttpClient.Builder().callTimeout(serviceBuilder.callTimeout).connectTimeout(serviceBuilder.connectTimeout).readTimeout(serviceBuilder.readTimeout).writeTimeout(serviceBuilder.writeTimeout).addInterceptor((Interceptor)new RequestLoggingInterceptor(serviceBuilder.logLevel)).addInterceptor((Interceptor)new ResponseLoggingInterceptor(serviceBuilder.logLevel)).addInterceptor((Interceptor)new AuthorizationHeaderInjector(serviceBuilder.searchApiKey)).build();
        Retrofit.Builder searchRetrofitBuilder = new Retrofit.Builder().baseUrl(serviceBuilder.searchEndpoint).client(searchOkHttpClient);
        searchRetrofitBuilder.addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)Json.OBJECT_MAPPER));
        this.searchApi = (SearchApi)searchRetrofitBuilder.build().create(SearchApi.class);
    }

    @Override
    public void shutdown() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        Cache cache = this.okHttpClient.cache();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException e) {
                log.error("Failed to close cache", (Throwable)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public SyncOrAsyncOrStreaming<CompletionResponse> completion(OpenAiClient.OpenAiClientContext context, CompletionRequest request) {
        CompletionRequest syncRequest = CompletionRequest.builder().from(request).stream(false).build();
        return new RequestExecutor<CompletionRequest, CompletionResponse, CompletionResponse>(this.openAiApi.completions(context.headers(), syncRequest, this.apiVersion), r -> r, this.okHttpClient, this.formatUrl("completions"), () -> CompletionRequest.builder().from(request).stream(true).build(), CompletionResponse.class, r -> r, this.logStreamingResponses);
    }

    @Override
    public SyncOrAsyncOrStreaming<String> completion(OpenAiClient.OpenAiClientContext context, String prompt) {
        CompletionRequest request = CompletionRequest.builder().prompt(prompt).build();
        CompletionRequest syncRequest = CompletionRequest.builder().from(request).stream(false).build();
        return new RequestExecutor<CompletionRequest, CompletionResponse, String>(this.openAiApi.completions(context.headers(), syncRequest, this.apiVersion), CompletionResponse::text, this.okHttpClient, this.formatUrl("completions"), () -> CompletionRequest.builder().from(request).stream(true).build(), CompletionResponse.class, CompletionResponse::text, this.logStreamingResponses);
    }

    @Override
    public SyncOrAsyncOrStreaming<ChatCompletionResponse> chatCompletion(OpenAiClient.OpenAiClientContext context, ChatCompletionRequest request) {
        ChatCompletionRequest syncRequest = ChatCompletionRequest.builder().from(request).stream(false).build();
        return new RequestExecutor<ChatCompletionRequest, ChatCompletionResponse, ChatCompletionResponse>(this.openAiApi.chatCompletions(context.headers(), syncRequest, this.apiVersion), r -> r, this.okHttpClient, this.formatUrl("chat/completions"), () -> ChatCompletionRequest.builder().from(request).stream(true).build(), ChatCompletionResponse.class, r -> r, this.logStreamingResponses);
    }

    @Override
    public SyncOrAsyncOrStreaming<String> chatCompletion(OpenAiClient.OpenAiClientContext context, String userMessage) {
        ChatCompletionRequest request = ChatCompletionRequest.builder().addUserMessage(userMessage).build();
        ChatCompletionRequest syncRequest = ChatCompletionRequest.builder().from(request).stream(false).build();
        return new RequestExecutor<ChatCompletionRequest, ChatCompletionResponse, String>(this.openAiApi.chatCompletions(context.headers(), syncRequest, this.apiVersion), ChatCompletionResponse::content, this.okHttpClient, this.formatUrl("chat/completions"), () -> ChatCompletionRequest.builder().from(request).stream(true).build(), ChatCompletionResponse.class, r -> r.choices().get(0).delta().content(), this.logStreamingResponses);
    }

    @Override
    public Flux<ChatCompletionResponse> chatFluxCompletion(ChatCompletionRequest request) {
        if (Objects.nonNull(this.model)) {
            request = ChatCompletionRequest.builder().from(request).model(this.model).build();
        }
        ChatCompletionRequest finalRequest = request;
        return Flux.create(emitter -> this.chatCompletion(new OpenAiClient.OpenAiClientContext(), finalRequest).onPartialResponse(arg_0 -> ((FluxSink)emitter).next(arg_0)).onComplete(() -> ((FluxSink)emitter).complete()).onError(arg_0 -> ((FluxSink)emitter).error(arg_0)).execute());
    }

    public Flux<ChatCompletionResponse> chatSearchCompletion(String userMessage) {
        SearchResponse searchResponse = new SyncRequestExecutor<SearchResponse, SearchResponse>(this.searchApi.webSearch(SearchRequest.builder().enable(true).query(userMessage).build()), searchResponse1 -> searchResponse1).execute();
        if (200 == searchResponse.getCode()) {
            String formatted = Utils.format(userMessage, searchResponse.getData().getWebPages().getValue());
            if (Objects.nonNull(formatted)) {
                return this.chatFluxCompletion(formatted);
            }
            return this.chatFluxCompletion(userMessage);
        }
        return this.chatFluxCompletion(userMessage);
    }

    public SyncOrAsyncOrStreaming<ChatCompletionResponse> chatSearchStreamingCompletion(String userMessage) {
        String formatted;
        SearchResponse searchResponse = new SyncRequestExecutor<SearchResponse, SearchResponse>(this.searchApi.webSearch(SearchRequest.builder().enable(true).query(userMessage).build()), searchResponse1 -> searchResponse1).execute();
        if (200 == searchResponse.getCode() && Objects.nonNull(formatted = Utils.format(userMessage, searchResponse.getData().getWebPages().getValue()))) {
            return this.chatCompletion(new OpenAiClient.OpenAiClientContext(), ChatCompletionRequest.builder().stream(true).model(this.model).addUserMessage(formatted).build());
        }
        return this.chatCompletion(new OpenAiClient.OpenAiClientContext(), ChatCompletionRequest.builder().stream(true).model(this.model).addUserMessage(userMessage).build());
    }

    public Flux<ChatCompletionResponse> chatSearchCompletion(String userMessage, SearchRequest searchRequest) {
        SearchResponse searchResponse;
        if (Objects.isNull(searchRequest.getQuery())) {
            searchRequest.setQuery(userMessage);
        }
        if (200 == (searchResponse = new SyncRequestExecutor<SearchResponse, SearchResponse>(this.searchApi.webSearch(searchRequest), searchResponse1 -> searchResponse1).execute()).getCode()) {
            String formatted = Utils.format(userMessage, searchResponse.getData().getWebPages().getValue());
            if (Objects.nonNull(formatted)) {
                return this.chatFluxCompletion(formatted);
            }
            return this.chatFluxCompletion(userMessage);
        }
        return this.chatFluxCompletion(userMessage);
    }

    @Override
    public Flux<ChatCompletionResponse> chatFluxCompletion(String userMessage) {
        ChatCompletionRequest.Builder builder = ChatCompletionRequest.builder();
        if (Objects.nonNull(this.systemMessage)) {
            builder.addSystemMessage(this.systemMessage);
        }
        if (Objects.nonNull(this.model)) {
            builder.model(this.model);
        }
        builder.addUserMessage(userMessage);
        return Flux.create(emitter -> this.chatCompletion(new OpenAiClient.OpenAiClientContext(), builder.build()).onPartialResponse(arg_0 -> ((FluxSink)emitter).next(arg_0)).onComplete(() -> ((FluxSink)emitter).complete()).onError(arg_0 -> ((FluxSink)emitter).error(arg_0)).execute());
    }

    @Override
    public SyncOrAsync<ModerationResponse> moderation(OpenAiClient.OpenAiClientContext context, ModerationRequest request) {
        return new RequestExecutor(this.openAiApi.moderations(context.headers(), request, this.apiVersion), r -> r);
    }

    @Override
    public SyncOrAsync<ModerationResult> moderation(OpenAiClient.OpenAiClientContext context, String input) {
        ModerationRequest request = ModerationRequest.builder().input(input).build();
        return new RequestExecutor(this.openAiApi.moderations(context.headers(), request, this.apiVersion), r -> r.results().get(0));
    }

    private String formatUrl(String endpoint) {
        return this.baseUrl + endpoint + this.apiVersionQueryParam();
    }

    private String apiVersionQueryParam() {
        if (this.apiVersion == null || this.apiVersion.trim().isEmpty()) {
            return "";
        }
        return "?api-version=" + this.apiVersion;
    }

    public static class Builder
    extends OpenAiClient.Builder<DeepSeekClient, Builder> {
        private String searchEndpoint = "https://api.bochaai.com/v1/";
        private String searchApiKey;
        private SearchApi searchApi;

        public Builder searchApi(SearchApi searchApi) {
            this.searchApi = searchApi;
            return this;
        }

        public Builder searchApiKey(String searchApiKey) {
            this.searchApiKey = searchApiKey;
            return this;
        }

        public Builder searchEndpoint(String searchEndpoint) {
            this.searchEndpoint = searchEndpoint;
            return this;
        }

        @Override
        public DeepSeekClient build() {
            return new DeepSeekClient(this);
        }
    }
}

