/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.core;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.pigmesh.ai.deepseek.core.ApiKeyHeaderInjector;
import io.github.pigmesh.ai.deepseek.core.AuthorizationHeaderInjector;
import io.github.pigmesh.ai.deepseek.core.GenericHeaderInjector;
import io.github.pigmesh.ai.deepseek.core.Json;
import io.github.pigmesh.ai.deepseek.core.OpenAiApi;
import io.github.pigmesh.ai.deepseek.core.OpenAiClient;
import io.github.pigmesh.ai.deepseek.core.PersistorConverterFactory;
import io.github.pigmesh.ai.deepseek.core.RequestExecutor;
import io.github.pigmesh.ai.deepseek.core.RequestLoggingInterceptor;
import io.github.pigmesh.ai.deepseek.core.ResponseLoggingInterceptor;
import io.github.pigmesh.ai.deepseek.core.SyncOrAsync;
import io.github.pigmesh.ai.deepseek.core.embedding.EmbeddingRequest;
import io.github.pigmesh.ai.deepseek.core.embedding.EmbeddingResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import okhttp3.Cache;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class EmbeddingClient
extends OpenAiClient {
    private static final Logger log = LoggerFactory.getLogger(EmbeddingClient.class);
    private final String baseUrl;
    private final String model;
    private final String apiVersion;
    private final OkHttpClient okHttpClient;
    private final OpenAiApi openAiApi;
    private final boolean logStreamingResponses;

    public EmbeddingClient(String apiKey) {
        this((Builder)new Builder().openAiApiKey(apiKey));
    }

    private EmbeddingClient(Builder serviceBuilder) {
        this.baseUrl = serviceBuilder.baseUrl;
        this.apiVersion = serviceBuilder.apiVersion;
        this.model = serviceBuilder.model;
        OkHttpClient.Builder okHttpClientBuilder = new OkHttpClient.Builder().callTimeout(serviceBuilder.callTimeout).connectTimeout(serviceBuilder.connectTimeout).readTimeout(serviceBuilder.readTimeout).writeTimeout(serviceBuilder.writeTimeout);
        if (serviceBuilder.dispatcher != null) {
            okHttpClientBuilder.dispatcher(serviceBuilder.dispatcher);
        }
        if (serviceBuilder.openAiApiKey != null) {
            okHttpClientBuilder.addInterceptor((Interceptor)new AuthorizationHeaderInjector(serviceBuilder.openAiApiKey));
        } else {
            okHttpClientBuilder.addInterceptor((Interceptor)new ApiKeyHeaderInjector(serviceBuilder.azureApiKey));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (serviceBuilder.organizationId != null) {
            headers.put("OpenAI-Organization", serviceBuilder.organizationId);
        }
        if (serviceBuilder.userAgent != null) {
            headers.put("User-Agent", serviceBuilder.userAgent);
        }
        if (serviceBuilder.customHeaders != null) {
            headers.putAll(serviceBuilder.customHeaders);
        }
        if (!headers.isEmpty()) {
            okHttpClientBuilder.addInterceptor((Interceptor)new GenericHeaderInjector(headers));
        }
        if (serviceBuilder.proxy != null) {
            okHttpClientBuilder.proxy(serviceBuilder.proxy);
        }
        if (serviceBuilder.logRequests) {
            okHttpClientBuilder.addInterceptor((Interceptor)new RequestLoggingInterceptor(serviceBuilder.logLevel));
        }
        if (serviceBuilder.logResponses) {
            okHttpClientBuilder.addInterceptor((Interceptor)new ResponseLoggingInterceptor(serviceBuilder.logLevel));
        }
        this.logStreamingResponses = serviceBuilder.logStreamingResponses;
        this.okHttpClient = okHttpClientBuilder.build();
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(serviceBuilder.baseUrl).client(this.okHttpClient);
        if (serviceBuilder.persistTo != null) {
            retrofitBuilder.addConverterFactory((Converter.Factory)new PersistorConverterFactory(serviceBuilder.persistTo));
        }
        retrofitBuilder.addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)Json.OBJECT_MAPPER));
        this.openAiApi = (OpenAiApi)retrofitBuilder.build().create(OpenAiApi.class);
    }

    @Override
    public void shutdown() {
        this.okHttpClient.dispatcher().executorService().shutdown();
        this.okHttpClient.connectionPool().evictAll();
        Cache cache = this.okHttpClient.cache();
        if (cache != null) {
            try {
                cache.close();
            }
            catch (IOException e) {
                log.error("Failed to close cache", (Throwable)e);
            }
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public EmbeddingResponse embed(EmbeddingRequest request) {
        return this.embedding(new OpenAiClient.OpenAiClientContext(), request).execute();
    }

    public List<Float> embed(String input) {
        return this.embedding(new OpenAiClient.OpenAiClientContext(), input).execute();
    }

    @Override
    public SyncOrAsync<EmbeddingResponse> embedding(OpenAiClient.OpenAiClientContext context, EmbeddingRequest request) {
        if (Objects.isNull(request.getModel())) {
            request.setModel(this.model);
        }
        return new RequestExecutor(this.openAiApi.embeddings(context.headers(), request, this.apiVersion), r -> r);
    }

    @Override
    public SyncOrAsync<List<Float>> embedding(OpenAiClient.OpenAiClientContext context, String input) {
        EmbeddingRequest.Builder builder = EmbeddingRequest.builder().input(input);
        if (Objects.nonNull(this.model)) {
            builder.model(this.model);
        }
        return new RequestExecutor(this.openAiApi.embeddings(context.headers(), builder.build(), this.apiVersion), EmbeddingResponse::embedding);
    }

    public static class Builder
    extends OpenAiClient.Builder<EmbeddingClient, Builder> {
        @Override
        public EmbeddingClient build() {
            return new EmbeddingClient(this);
        }
    }
}

