/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.core;

import io.github.pigmesh.ai.deepseek.core.OpenAiHttpException;
import io.github.pigmesh.ai.deepseek.core.search.SearchResponse;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.Objects;
import java.util.stream.Collectors;
import okhttp3.Response;

public class Utils {
    static RuntimeException toException(retrofit2.Response<?> response) throws IOException {
        return new OpenAiHttpException(response.code(), response.errorBody().string());
    }

    static RuntimeException toException(Response response) throws IOException {
        return new OpenAiHttpException(response.code(), response.body().string());
    }

    static <T> T getOrDefault(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static String format(String user, SearchResponse.Value[] values) {
        if (Objects.isNull(values) || values.length == 0) {
            return null;
        }
        String results = Arrays.stream(values).map(organicResult -> "Title: " + organicResult.getName() + "\nSource: " + organicResult.getUrl() + "\n" + (organicResult.getSummary() != null ? "Content:\n" + organicResult.getSummary() : "Snippet:\n" + organicResult.getSnippet())).collect(Collectors.joining("\n\n"));
        return String.format("\u7528\u6237\u8f93\u5165\u63d0\u95ee: %s\n\n \u5f53\u524d\u65f6\u95f4:%s \n\n \u53c2\u8003\u5982\u4e0b\u5185\u5bb9\u8fdb\u884c\u63a8\u7406\u56de\u7b54:%s", user, LocalDateTime.now().format(DateTimeFormatter.ISO_DATE_TIME), results);
    }
}

