/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.core.chat;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.pigmesh.ai.deepseek.core.chat.JsonSchemaElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class JsonEnumSchema
extends JsonSchemaElement {
    @JsonProperty
    private final String description;
    @JsonProperty(value="enum")
    private final List<String> enumValues;

    public JsonEnumSchema(Builder builder) {
        super("string");
        this.description = builder.description;
        this.enumValues = new ArrayList<String>(builder.enumValues);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof JsonEnumSchema && this.equalTo((JsonEnumSchema)another);
    }

    private boolean equalTo(JsonEnumSchema another) {
        return Objects.equals(this.description, another.description) && Objects.equals(this.enumValues, another.enumValues);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.description);
        h += (h << 5) + Objects.hashCode(this.enumValues);
        return h;
    }

    public String toString() {
        return "JsonEnumSchema{description=" + this.description + ", enumValues=" + this.enumValues + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Builder {
        private String description;
        private List<String> enumValues;

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder enumValues(List<String> enumValues) {
            this.enumValues = enumValues;
            return this;
        }

        public Builder enumValues(Class<?> enumClass) {
            if (!enumClass.isEnum()) {
                throw new RuntimeException("Class " + enumClass.getName() + " must be enum");
            }
            List<String> enumValues = Arrays.stream(enumClass.getEnumConstants()).map(Object::toString).collect(Collectors.toList());
            return this.enumValues(enumValues);
        }

        public JsonEnumSchema build() {
            return new JsonEnumSchema(this);
        }
    }
}

