/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.core.chat;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.pigmesh.ai.deepseek.core.chat.JsonSchema;
import io.github.pigmesh.ai.deepseek.core.chat.ResponseFormatType;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public class ResponseFormat {
    @JsonProperty
    private final ResponseFormatType type;
    @JsonProperty
    private final JsonSchema jsonSchema;

    @JsonCreator
    public ResponseFormat(Builder builder) {
        this.type = builder.type;
        this.jsonSchema = builder.jsonSchema;
    }

    public ResponseFormatType type() {
        return this.type;
    }

    public JsonSchema jsonSchema() {
        return this.jsonSchema;
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ResponseFormat && this.equalTo((ResponseFormat)another);
    }

    private boolean equalTo(ResponseFormat another) {
        return Objects.equals((Object)this.type, (Object)another.type) && Objects.equals(this.jsonSchema, another.jsonSchema);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode((Object)this.type);
        h += (h << 5) + Objects.hashCode(this.jsonSchema);
        return h;
    }

    public String toString() {
        return "ResponseFormat{type=" + (Object)((Object)this.type) + ", jsonSchema=" + this.jsonSchema + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static class Builder {
        private ResponseFormatType type;
        private JsonSchema jsonSchema;

        public Builder type(ResponseFormatType type) {
            this.type = type;
            return this;
        }

        public Builder jsonSchema(JsonSchema jsonSchema) {
            this.jsonSchema = jsonSchema;
            return this;
        }

        public ResponseFormat build() {
            return new ResponseFormat(this);
        }
    }
}

