/*
 * Decompiled with CFR 0.152.
 */
package io.github.pigmesh.ai.deepseek.core.embedding;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonNaming;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import io.github.pigmesh.ai.deepseek.core.embedding.Embedding;
import io.github.pigmesh.ai.deepseek.core.shared.Usage;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonDeserialize(builder=Builder.class)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
public final class EmbeddingResponse {
    @JsonProperty
    private final String model;
    @JsonProperty
    private final List<Embedding> data;
    @JsonProperty
    private final Usage usage;

    private EmbeddingResponse(Builder builder) {
        this.model = builder.model;
        this.data = builder.data;
        this.usage = builder.usage;
    }

    public String model() {
        return this.model;
    }

    public List<Embedding> data() {
        return this.data;
    }

    public Usage usage() {
        return this.usage;
    }

    public List<Float> embedding() {
        return this.data.get(0).embedding();
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmbeddingResponse && this.equalTo((EmbeddingResponse)another);
    }

    private boolean equalTo(EmbeddingResponse another) {
        return Objects.equals(this.model, another.model) && Objects.equals(this.data, another.data) && Objects.equals(this.usage, another.usage);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.model);
        h += (h << 5) + Objects.hashCode(this.data);
        h += (h << 5) + Objects.hashCode(this.usage);
        return h;
    }

    public String toString() {
        return "EmbeddingResponse{model=" + this.model + ", data=" + this.data + ", usage=" + this.usage + "}";
    }

    public static Builder builder() {
        return new Builder();
    }

    @JsonPOJOBuilder(withPrefix="")
    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonNaming(value=PropertyNamingStrategies.SnakeCaseStrategy.class)
    public static final class Builder {
        private String model;
        private List<Embedding> data;
        private Usage usage;

        private Builder() {
        }

        public Builder model(String model) {
            this.model = model;
            return this;
        }

        public Builder data(List<Embedding> data) {
            if (data != null) {
                this.data = Collections.unmodifiableList(data);
            }
            return this;
        }

        public Builder usage(Usage usage) {
            this.usage = usage;
            return this;
        }

        public EmbeddingResponse build() {
            return new EmbeddingResponse(this);
        }
    }
}

