/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.auth.impl;

import com.alibaba.nacos.common.tls.TlsHelper;
import com.alibaba.nacos.core.utils.Loggers;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSocketFactory;
import org.springframework.ldap.core.support.LdapContextSource;

public class NacosLdapContextSource
extends LdapContextSource {
    private final Map<String, Object> config = new HashMap<String, Object>(16);
    private boolean useTsl = false;
    private static final String LDAPS = "ldaps";

    public NacosLdapContextSource(String ldapUrl, String ldapBaseDc, String userDn, String password, String ldapTimeOut) {
        this.setUrl(ldapUrl);
        this.setBase(ldapBaseDc);
        this.setUserDn(userDn);
        this.setPassword(password);
        if (ldapUrl.toLowerCase().startsWith(LDAPS)) {
            this.useTsl = true;
        }
        this.setPooled(true);
        this.init(ldapTimeOut);
    }

    public void init(String ldapTimeOut) {
        if (this.useTsl) {
            System.setProperty("com.sun.jndi.ldap.object.disableEndpointIdentification", "true");
            this.config.put("java.naming.security.protocol", "ssl");
            this.config.put("java.naming.ldap.factory.socket", LdapSslSocketFactory.class.getName());
            this.config.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        }
        this.config.put("java.naming.ldap.attributes.binary", "objectGUID");
        this.config.put("com.sun.jndi.ldap.connect.timeout", ldapTimeOut);
        this.setBaseEnvironmentProperties(this.config);
        this.afterPropertiesSet();
    }

    public static class LdapSslSocketFactory
    extends SSLSocketFactory {
        private SSLSocketFactory socketFactory;

        public LdapSslSocketFactory() {
            try {
                this.socketFactory = TlsHelper.buildSslContext((boolean)true).getSocketFactory();
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                Loggers.AUTH.error("Failed to create SSLContext", (Throwable)e);
            }
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.socketFactory.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.socketFactory.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            return this.socketFactory.createSocket(socket, s, i, b);
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException {
            return this.socketFactory.createSocket(s, i);
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException {
            return this.socketFactory.createSocket(s, i, inetAddress, i1);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.socketFactory.createSocket(inetAddress, i);
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.socketFactory.createSocket(inetAddress, i, inetAddress1, i1);
        }
    }
}

