/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.common.remote.client.grpc;

import com.alibaba.nacos.api.ability.constant.AbilityMode;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.grpc.auto.BiRequestStreamGrpc;
import com.alibaba.nacos.api.grpc.auto.Payload;
import com.alibaba.nacos.api.grpc.auto.RequestGrpc;
import com.alibaba.nacos.api.remote.request.ConnectResetRequest;
import com.alibaba.nacos.api.remote.request.ConnectionSetupRequest;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.ServerCheckRequest;
import com.alibaba.nacos.api.remote.request.SetupAckRequest;
import com.alibaba.nacos.api.remote.response.ErrorResponse;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.api.remote.response.ServerCheckResponse;
import com.alibaba.nacos.api.remote.response.SetupAckResponse;
import com.alibaba.nacos.common.ability.discover.NacosAbilityManagerHolder;
import com.alibaba.nacos.common.packagescan.resource.Resource;
import com.alibaba.nacos.common.remote.ConnectionType;
import com.alibaba.nacos.common.remote.TlsConfig;
import com.alibaba.nacos.common.remote.client.Connection;
import com.alibaba.nacos.common.remote.client.RpcClient;
import com.alibaba.nacos.common.remote.client.RpcClientStatus;
import com.alibaba.nacos.common.remote.client.RpcClientTlsConfig;
import com.alibaba.nacos.common.remote.client.ServerListFactory;
import com.alibaba.nacos.common.remote.client.ServerRequestHandler;
import com.alibaba.nacos.common.remote.client.grpc.DefaultGrpcClientConfig;
import com.alibaba.nacos.common.remote.client.grpc.GrpcClientConfig;
import com.alibaba.nacos.common.remote.client.grpc.GrpcConnection;
import com.alibaba.nacos.common.remote.client.grpc.GrpcUtils;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.common.utils.ThreadFactoryBuilder;
import com.alibaba.nacos.common.utils.TlsTypeResolve;
import com.alibaba.nacos.common.utils.VersionUtils;
import com.google.common.util.concurrent.ListenableFuture;
import io.grpc.Channel;
import io.grpc.CompressorRegistry;
import io.grpc.DecompressorRegistry;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import io.grpc.netty.shaded.io.grpc.netty.GrpcSslContexts;
import io.grpc.netty.shaded.io.grpc.netty.NegotiationType;
import io.grpc.netty.shaded.io.grpc.netty.NettyChannelBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContext;
import io.grpc.netty.shaded.io.netty.handler.ssl.SslContextBuilder;
import io.grpc.netty.shaded.io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.grpc.stub.StreamObserver;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GrpcClient
extends RpcClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(GrpcClient.class);
    private final GrpcClientConfig clientConfig;
    private ThreadPoolExecutor grpcExecutor;
    private final RecAbilityContext recAbilityContext = new RecAbilityContext(null);
    private SetupRequestHandler setupRequestHandler;

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.GRPC;
    }

    public GrpcClient(String name) {
        this(DefaultGrpcClientConfig.newBuilder().setName(name).build());
    }

    public GrpcClient(GrpcClientConfig clientConfig) {
        super(clientConfig);
        this.clientConfig = clientConfig;
        this.initSetupHandler();
    }

    public GrpcClient(GrpcClientConfig clientConfig, ServerListFactory serverListFactory) {
        super(clientConfig, serverListFactory);
        this.clientConfig = clientConfig;
        this.initSetupHandler();
    }

    private void initSetupHandler() {
        this.setupRequestHandler = new SetupRequestHandler(this.recAbilityContext);
    }

    public GrpcClient(String name, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels) {
        this(DefaultGrpcClientConfig.newBuilder().setName(name).setThreadPoolCoreSize(threadPoolCoreSize).setThreadPoolMaxSize(threadPoolMaxSize).setLabels(labels).build());
    }

    public GrpcClient(String name, Integer threadPoolCoreSize, Integer threadPoolMaxSize, Map<String, String> labels, RpcClientTlsConfig tlsConfig) {
        this(DefaultGrpcClientConfig.newBuilder().setName(name).setThreadPoolCoreSize(threadPoolCoreSize).setTlsConfig(tlsConfig).setThreadPoolMaxSize(threadPoolMaxSize).setLabels(labels).build());
    }

    protected ThreadPoolExecutor createGrpcExecutor(String serverIp) {
        serverIp = serverIp.replaceAll("%", "-");
        ThreadPoolExecutor grpcExecutor = new ThreadPoolExecutor(this.clientConfig.threadPoolCoreSize(), this.clientConfig.threadPoolMaxSize(), this.clientConfig.threadPoolKeepAlive(), TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(this.clientConfig.threadPoolQueueSize()), new ThreadFactoryBuilder().daemon(true).nameFormat("nacos-grpc-client-executor-" + serverIp + "-%d").build());
        grpcExecutor.allowCoreThreadTimeOut(true);
        return grpcExecutor;
    }

    @Override
    public void shutdown() throws NacosException {
        super.shutdown();
        if (this.grpcExecutor != null) {
            LOGGER.info("Shutdown grpc executor " + this.grpcExecutor);
            this.grpcExecutor.shutdown();
        }
    }

    protected RequestGrpc.RequestFutureStub createNewChannelStub(ManagedChannel managedChannelTemp) {
        return RequestGrpc.newFutureStub((Channel)managedChannelTemp);
    }

    private ManagedChannel createNewManagedChannel(String serverIp, int serverPort) {
        LOGGER.info("grpc client connection server:{} ip,serverPort:{},grpcTslConfig:{}", new Object[]{serverIp, serverPort, JacksonUtils.toJson(this.clientConfig.tlsConfig())});
        ManagedChannelBuilder managedChannelBuilder = this.buildChannel(serverIp, serverPort, this.buildSslContext()).executor((Executor)this.grpcExecutor).compressorRegistry(CompressorRegistry.getDefaultInstance()).decompressorRegistry(DecompressorRegistry.getDefaultInstance()).maxInboundMessageSize(this.clientConfig.maxInboundMessageSize()).keepAliveTime((long)this.clientConfig.channelKeepAlive(), TimeUnit.MILLISECONDS).keepAliveTimeout(this.clientConfig.channelKeepAliveTimeout(), TimeUnit.MILLISECONDS);
        return managedChannelBuilder.build();
    }

    private void shuntDownChannel(ManagedChannel managedChannel) {
        if (managedChannel != null && !managedChannel.isShutdown()) {
            managedChannel.shutdownNow();
        }
    }

    private Response serverCheck(String ip, int port, RequestGrpc.RequestFutureStub requestBlockingStub) {
        try {
            ServerCheckRequest serverCheckRequest = new ServerCheckRequest();
            Payload grpcRequest = GrpcUtils.convert((Request)serverCheckRequest);
            ListenableFuture responseFuture = requestBlockingStub.request(grpcRequest);
            Payload response = (Payload)responseFuture.get(this.clientConfig.serverCheckTimeOut(), TimeUnit.MILLISECONDS);
            return (Response)GrpcUtils.parse(response);
        }
        catch (Exception e) {
            LoggerUtils.printIfErrorEnabled(LOGGER, "Server check fail, please check server {} ,port {} is available , error ={}", ip, port, e);
            if (this.clientConfig != null && this.clientConfig.tlsConfig() != null && this.clientConfig.tlsConfig().getEnableTls().booleanValue()) {
                LoggerUtils.printIfErrorEnabled(LOGGER, "current client is require tls encrypted ,server must support tls ,please check", new Object[0]);
            }
            return null;
        }
    }

    private StreamObserver<Payload> bindRequestStream(BiRequestStreamGrpc.BiRequestStreamStub streamStub, final GrpcConnection grpcConn) {
        return streamStub.requestBiStream((StreamObserver)new StreamObserver<Payload>(){

            public void onNext(Payload payload) {
                block6: {
                    LoggerUtils.printIfDebugEnabled(LOGGER, "[{}]Stream server request receive, original info: {}", grpcConn.getConnectionId(), payload.toString());
                    try {
                        Object parseBody = GrpcUtils.parse(payload);
                        Request request = (Request)parseBody;
                        if (request == null) break block6;
                        try {
                            if (request instanceof SetupAckRequest) {
                                GrpcClient.this.setupRequestHandler.requestReply(request, null);
                                return;
                            }
                            Response response = GrpcClient.this.handleServerRequest(request);
                            if (response != null) {
                                response.setRequestId(request.getRequestId());
                                GrpcClient.this.sendResponse(response);
                                break block6;
                            }
                            LOGGER.warn("[{}]Fail to process server request, ackId->{}", (Object)grpcConn.getConnectionId(), (Object)request.getRequestId());
                        }
                        catch (Exception e) {
                            LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Handle server request exception: {}", grpcConn.getConnectionId(), payload.toString(), e.getMessage());
                            Response errResponse = ErrorResponse.build((int)-500, (String)"Handle server request error");
                            errResponse.setRequestId(request.getRequestId());
                            GrpcClient.this.sendResponse(errResponse);
                        }
                    }
                    catch (Exception e) {
                        LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Error to process server push response: {}", grpcConn.getConnectionId(), payload.getBody().getValue().toStringUtf8());
                        GrpcClient.this.recAbilityContext.release(null);
                    }
                }
            }

            public void onError(Throwable throwable) {
                boolean isRunning = GrpcClient.this.isRunning();
                boolean isAbandon = grpcConn.isAbandon();
                if (isRunning && !isAbandon) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Request stream error, switch server,error={}", grpcConn.getConnectionId(), throwable);
                    if (GrpcClient.this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                        GrpcClient.this.switchServerAsync();
                    }
                } else {
                    LoggerUtils.printIfWarnEnabled(LOGGER, "[{}]Ignore error event,isRunning:{},isAbandon={}", grpcConn.getConnectionId(), isRunning, isAbandon);
                }
            }

            public void onCompleted() {
                boolean isRunning = GrpcClient.this.isRunning();
                boolean isAbandon = grpcConn.isAbandon();
                if (isRunning && !isAbandon) {
                    LoggerUtils.printIfErrorEnabled(LOGGER, "[{}]Request stream onCompleted, switch server", grpcConn.getConnectionId());
                    if (GrpcClient.this.rpcClientStatus.compareAndSet(RpcClientStatus.RUNNING, RpcClientStatus.UNHEALTHY)) {
                        GrpcClient.this.switchServerAsync();
                    }
                } else {
                    LoggerUtils.printIfInfoEnabled(LOGGER, "[{}]Ignore complete event,isRunning:{},isAbandon={}", grpcConn.getConnectionId(), isRunning, isAbandon);
                }
            }
        });
    }

    private void sendResponse(Response response) {
        try {
            ((GrpcConnection)this.currentConnection).sendResponse(response);
        }
        catch (Exception e) {
            LOGGER.error("[{}]Error to send ack response, ackId->{}", (Object)this.currentConnection.getConnectionId(), (Object)response.getRequestId());
        }
    }

    @Override
    public Connection connectToServer(RpcClient.ServerInfo serverInfo) {
        String connectionId = "";
        try {
            if (this.grpcExecutor == null) {
                this.grpcExecutor = this.createGrpcExecutor(serverInfo.getServerIp());
            }
            int port = serverInfo.getServerPort() + this.rpcPortOffset();
            ManagedChannel managedChannel = this.createNewManagedChannel(serverInfo.getServerIp(), port);
            RequestGrpc.RequestFutureStub newChannelStubTemp = this.createNewChannelStub(managedChannel);
            Response response = this.serverCheck(serverInfo.getServerIp(), port, newChannelStubTemp);
            if (!(response instanceof ServerCheckResponse)) {
                this.shuntDownChannel(managedChannel);
                return null;
            }
            ServerCheckResponse serverCheckResponse = (ServerCheckResponse)response;
            connectionId = serverCheckResponse.getConnectionId();
            BiRequestStreamGrpc.BiRequestStreamStub biRequestStreamStub = BiRequestStreamGrpc.newStub((Channel)newChannelStubTemp.getChannel());
            GrpcConnection grpcConn = new GrpcConnection(serverInfo, this.grpcExecutor);
            grpcConn.setConnectionId(connectionId);
            if (serverCheckResponse.isSupportAbilityNegotiation()) {
                this.recAbilityContext.reset(grpcConn);
                grpcConn.setAbilityTable(null);
            }
            StreamObserver<Payload> payloadStreamObserver = this.bindRequestStream(biRequestStreamStub, grpcConn);
            grpcConn.setPayloadStreamObserver(payloadStreamObserver);
            grpcConn.setGrpcFutureServiceStub(newChannelStubTemp);
            grpcConn.setChannel(managedChannel);
            ConnectionSetupRequest conSetupRequest = new ConnectionSetupRequest();
            conSetupRequest.setClientVersion(VersionUtils.getFullClientVersion());
            conSetupRequest.setLabels(super.getLabels());
            conSetupRequest.setAbilityTable(NacosAbilityManagerHolder.getInstance().getCurrentNodeAbilities(this.abilityMode()));
            conSetupRequest.setTenant(super.getTenant());
            grpcConn.sendRequest((Request)conSetupRequest);
            if (this.recAbilityContext.isNeedToSync()) {
                this.recAbilityContext.await(this.clientConfig.capabilityNegotiationTimeout(), TimeUnit.MILLISECONDS);
                if (!this.recAbilityContext.check(grpcConn)) {
                    return null;
                }
            } else {
                Thread.sleep(100L);
            }
            return grpcConn;
        }
        catch (Exception e) {
            LOGGER.error("[{}]Fail to connect to server!,error={}", (Object)this.getName(), (Object)e);
            this.recAbilityContext.release(null);
            return null;
        }
    }

    protected abstract AbilityMode abilityMode();

    @Override
    protected void afterReset(ConnectResetRequest request) {
        this.recAbilityContext.release(null);
    }

    private Optional<SslContext> buildSslContext() {
        TlsConfig tlsConfig = this.clientConfig.tlsConfig();
        if (!tlsConfig.getEnableTls().booleanValue()) {
            return Optional.empty();
        }
        try {
            SslContextBuilder builder = GrpcSslContexts.forClient();
            if (StringUtils.isNotBlank(tlsConfig.getSslProvider())) {
                builder.sslProvider(TlsTypeResolve.getSslProvider(tlsConfig.getSslProvider()));
            }
            if (StringUtils.isNotBlank(tlsConfig.getProtocols())) {
                builder.protocols(tlsConfig.getProtocols().split(","));
            }
            if (StringUtils.isNotBlank(tlsConfig.getCiphers())) {
                builder.ciphers(Arrays.asList(tlsConfig.getCiphers().split(",")));
            }
            if (tlsConfig.getTrustAll().booleanValue()) {
                builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
            } else {
                if (StringUtils.isBlank(tlsConfig.getTrustCollectionCertFile())) {
                    throw new IllegalArgumentException("trustCollectionCertFile must be not null");
                }
                Resource resource = this.resourceLoader.getResource(tlsConfig.getTrustCollectionCertFile());
                builder.trustManager(resource.getInputStream());
            }
            if (tlsConfig.getMutualAuthEnable().booleanValue()) {
                if (StringUtils.isBlank(tlsConfig.getCertChainFile()) || StringUtils.isBlank(tlsConfig.getCertPrivateKey())) {
                    throw new IllegalArgumentException("client certChainFile or certPrivateKey must be not null");
                }
                Resource certChainFile = this.resourceLoader.getResource(tlsConfig.getCertChainFile());
                Resource privateKey = this.resourceLoader.getResource(tlsConfig.getCertPrivateKey());
                builder.keyManager(certChainFile.getInputStream(), privateKey.getInputStream(), tlsConfig.getCertPrivateKeyPassword());
            }
            return Optional.of(builder.build());
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to build SslContext", e);
        }
    }

    private ManagedChannelBuilder buildChannel(String serverIp, int port, Optional<SslContext> sslContext) {
        if (sslContext.isPresent()) {
            return NettyChannelBuilder.forAddress((String)serverIp, (int)port).negotiationType(NegotiationType.TLS).sslContext(sslContext.get());
        }
        return ManagedChannelBuilder.forAddress((String)serverIp, (int)port).usePlaintext();
    }

    static class RecAbilityContext {
        private volatile Connection connection;
        private volatile CountDownLatch blocker;
        private volatile boolean needToSync = false;

        public RecAbilityContext(Connection connection) {
            this.connection = connection;
            this.blocker = new CountDownLatch(1);
        }

        public boolean isNeedToSync() {
            return this.needToSync;
        }

        public void reset(Connection connection) {
            this.connection = connection;
            this.blocker = new CountDownLatch(1);
            this.needToSync = true;
        }

        public void release(Map<String, Boolean> abilities) {
            if (this.connection != null) {
                this.connection.setAbilityTable(abilities);
                this.connection = null;
            }
            if (this.blocker != null) {
                this.blocker.countDown();
            }
            this.needToSync = false;
        }

        public void await(long timeout, TimeUnit unit) throws InterruptedException {
            if (this.blocker != null) {
                this.blocker.await(timeout, unit);
            }
            this.needToSync = false;
        }

        public boolean check(Connection connection) {
            if (!connection.isAbilitiesSet()) {
                LOGGER.error("Client don't receive server abilities table even empty table but server supports ability negotiation. You can check if it is need to adjust the timeout of ability negotiation by property: {} if always fail to connect.", (Object)"nacos.remote.client.grpc.channel.capability.negotiation.timeout");
                connection.setAbandon(true);
                connection.close();
                return false;
            }
            return true;
        }
    }

    class SetupRequestHandler
    implements ServerRequestHandler {
        private final RecAbilityContext abilityContext;

        public SetupRequestHandler(RecAbilityContext abilityContext) {
            this.abilityContext = abilityContext;
        }

        @Override
        public Response requestReply(Request request, Connection connection) {
            if (request instanceof SetupAckRequest) {
                SetupAckRequest setupAckRequest = (SetupAckRequest)request;
                GrpcClient.this.recAbilityContext.release(Optional.ofNullable(setupAckRequest.getAbilityTable()).orElse(new HashMap(0)));
                return new SetupAckResponse();
            }
            return null;
        }
    }
}

