/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.remote;

import com.alibaba.nacos.api.config.remote.request.ConfigRemoveRequest;
import com.alibaba.nacos.api.config.remote.response.ConfigRemoveResponse;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.model.event.ConfigDataChangeEvent;
import com.alibaba.nacos.config.server.service.ConfigChangePublisher;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoTagPersistService;
import com.alibaba.nacos.config.server.service.trace.ConfigTraceService;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.config.server.utils.TimeUtils;
import com.alibaba.nacos.core.control.TpsControl;
import com.alibaba.nacos.core.paramcheck.ExtractorManager;
import com.alibaba.nacos.core.paramcheck.impl.ConfigRequestParamExtractor;
import com.alibaba.nacos.core.remote.RequestHandler;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.constant.ActionTypes;
import java.sql.Timestamp;
import org.springframework.stereotype.Component;

@Component
public class ConfigRemoveRequestHandler
extends RequestHandler<ConfigRemoveRequest, ConfigRemoveResponse> {
    private final ConfigInfoPersistService configInfoPersistService;
    private final ConfigInfoTagPersistService configInfoTagPersistService;

    public ConfigRemoveRequestHandler(ConfigInfoPersistService configInfoPersistService, ConfigInfoTagPersistService configInfoTagPersistService) {
        this.configInfoPersistService = configInfoPersistService;
        this.configInfoTagPersistService = configInfoTagPersistService;
    }

    @TpsControl(pointName="ConfigRemove")
    @Secured(action=ActionTypes.WRITE, signType="config")
    @ExtractorManager.Extractor(rpcExtractor=ConfigRequestParamExtractor.class)
    public ConfigRemoveResponse handle(ConfigRemoveRequest configRemoveRequest, RequestMeta meta) throws NacosException {
        String tenant = configRemoveRequest.getTenant();
        String dataId = configRemoveRequest.getDataId();
        String group = configRemoveRequest.getGroup();
        String tag = configRemoveRequest.getTag();
        try {
            ParamUtils.checkTenant(tenant);
            ParamUtils.checkParam(dataId, group, "datumId", "rm");
            ParamUtils.checkParam(tag);
            String persistEvent = "persist";
            String clientIp = meta.getClientIp();
            if (StringUtils.isBlank((CharSequence)tag)) {
                this.configInfoPersistService.removeConfigInfo(dataId, group, tenant, clientIp, null);
            } else {
                persistEvent = "persist-tag-" + tag;
                this.configInfoTagPersistService.removeConfigInfoTag(dataId, group, tenant, tag, clientIp, null);
            }
            Timestamp time = TimeUtils.getCurrentTime();
            ConfigTraceService.logPersistenceEvent(dataId, group, tenant, null, time.getTime(), clientIp, persistEvent, "remove", null);
            ConfigChangePublisher.notifyConfigChange(new ConfigDataChangeEvent(false, dataId, group, tenant, tag, time.getTime()));
            return ConfigRemoveResponse.buildSuccessResponse();
        }
        catch (Exception e) {
            Loggers.REMOTE_DIGEST.error("remove config error,error msg is {}", (Object)e.getMessage(), (Object)e);
            return ConfigRemoveResponse.buildFailResponse((String)e.getMessage());
        }
    }
}

