/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.auth;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.api.remote.request.RequestMeta;
import com.alibaba.nacos.api.remote.response.Response;
import com.alibaba.nacos.auth.GrpcProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.core.context.RequestContext;
import com.alibaba.nacos.core.context.RequestContextHolder;
import com.alibaba.nacos.core.remote.AbstractRequestFilter;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Permission;
import com.alibaba.nacos.plugin.auth.api.Resource;
import com.alibaba.nacos.plugin.auth.exception.AccessException;
import java.lang.reflect.Method;
import org.springframework.stereotype.Component;

@Component
public class RemoteRequestAuthFilter
extends AbstractRequestFilter {
    private final AuthConfigs authConfigs;
    private final GrpcProtocolAuthService protocolAuthService;

    public RemoteRequestAuthFilter(AuthConfigs authConfigs) {
        this.authConfigs = authConfigs;
        this.protocolAuthService = new GrpcProtocolAuthService(authConfigs);
        this.protocolAuthService.initialize();
    }

    @Override
    public Response filter(Request request, RequestMeta meta, Class handlerClazz) throws NacosException {
        try {
            Method method = this.getHandleMethod(handlerClazz);
            if (method.isAnnotationPresent(Secured.class) && this.authConfigs.isAuthEnabled()) {
                Secured secured;
                if (Loggers.AUTH.isDebugEnabled()) {
                    Loggers.AUTH.debug("auth start, request: {}", (Object)request.getClass().getSimpleName());
                }
                if (!this.protocolAuthService.enableAuth(secured = method.getAnnotation(Secured.class))) {
                    return null;
                }
                String clientIp = meta.getClientIp();
                request.putHeader("X-Real-IP", clientIp);
                Resource resource = this.protocolAuthService.parseResource(request, secured);
                IdentityContext identityContext = this.protocolAuthService.parseIdentity(request);
                boolean result = this.protocolAuthService.validateIdentity(identityContext, resource);
                RequestContext requestContext = RequestContextHolder.getContext();
                requestContext.getAuthContext().setIdentityContext(identityContext);
                requestContext.getAuthContext().setResource(resource);
                if (null == requestContext.getAuthContext().getAuthResult()) {
                    requestContext.getAuthContext().setAuthResult(result);
                }
                if (!result) {
                    throw new AccessException("Validate Identity failed.");
                }
                String action = secured.action().toString();
                result = this.protocolAuthService.validateAuthority(identityContext, new Permission(resource, action));
                if (!result) {
                    throw new AccessException("Validate Authority failed.");
                }
            }
        }
        catch (AccessException e) {
            if (Loggers.AUTH.isDebugEnabled()) {
                Loggers.AUTH.debug("access denied, request: {}, reason: {}", (Object)request.getClass().getSimpleName(), (Object)e.getErrMsg());
            }
            Response defaultResponseInstance = this.getDefaultResponseInstance(handlerClazz);
            defaultResponseInstance.setErrorInfo(403, e.getErrMsg());
            return defaultResponseInstance;
        }
        catch (Exception e) {
            Response defaultResponseInstance = this.getDefaultResponseInstance(handlerClazz);
            defaultResponseInstance.setErrorInfo(500, ExceptionUtil.getAllExceptionMsg((Throwable)e));
            return defaultResponseInstance;
        }
        return null;
    }
}

