/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro;

import com.alibaba.nacos.core.config.AbstractDynamicConfig;
import com.alibaba.nacos.sys.env.EnvUtil;

public class DistroConfig
extends AbstractDynamicConfig {
    private static final String DISTRO = "Distro";
    private static final DistroConfig INSTANCE = new DistroConfig();
    private long syncDelayMillis = 1000L;
    private long syncTimeoutMillis = 3000L;
    private long syncRetryDelayMillis = 3000L;
    private long verifyIntervalMillis = 5000L;
    private long verifyTimeoutMillis = 3000L;
    private long loadDataRetryDelayMillis = 30000L;
    private long loadDataTimeoutMillis = 30000L;

    private DistroConfig() {
        super(DISTRO);
        this.resetConfig();
    }

    @Override
    protected void getConfigFromEnv() {
        this.syncDelayMillis = (Long)EnvUtil.getProperty((String)"nacos.core.protocol.distro.data.sync.delayMs", Long.class, (Object)1000L);
        this.syncTimeoutMillis = (Long)EnvUtil.getProperty((String)"nacos.core.protocol.distro.data.sync.timeoutMs", Long.class, (Object)3000L);
        this.syncRetryDelayMillis = (Long)EnvUtil.getProperty((String)"nacos.core.protocol.distro.data.sync.retryDelayMs", Long.class, (Object)3000L);
        this.verifyIntervalMillis = (Long)EnvUtil.getProperty((String)"nacos.core.protocol.distro.data.verify.intervalMs", Long.class, (Object)5000L);
        this.verifyTimeoutMillis = (Long)EnvUtil.getProperty((String)"nacos.core.protocol.distro.data.verify.timeoutMs", Long.class, (Object)3000L);
        this.loadDataRetryDelayMillis = (Long)EnvUtil.getProperty((String)"nacos.core.protocol.distro.data.load.retryDelayMs", Long.class, (Object)30000L);
        this.loadDataTimeoutMillis = (Long)EnvUtil.getProperty((String)"nacos.core.protocol.distro.data.load.timeoutMs", Long.class, (Object)30000L);
    }

    public static DistroConfig getInstance() {
        return INSTANCE;
    }

    public long getSyncDelayMillis() {
        return this.syncDelayMillis;
    }

    public void setSyncDelayMillis(long syncDelayMillis) {
        this.syncDelayMillis = syncDelayMillis;
    }

    public long getSyncTimeoutMillis() {
        return this.syncTimeoutMillis;
    }

    public void setSyncTimeoutMillis(long syncTimeoutMillis) {
        this.syncTimeoutMillis = syncTimeoutMillis;
    }

    public long getSyncRetryDelayMillis() {
        return this.syncRetryDelayMillis;
    }

    public void setSyncRetryDelayMillis(long syncRetryDelayMillis) {
        this.syncRetryDelayMillis = syncRetryDelayMillis;
    }

    public long getVerifyIntervalMillis() {
        return this.verifyIntervalMillis;
    }

    public void setVerifyIntervalMillis(long verifyIntervalMillis) {
        this.verifyIntervalMillis = verifyIntervalMillis;
    }

    public long getVerifyTimeoutMillis() {
        return this.verifyTimeoutMillis;
    }

    public void setVerifyTimeoutMillis(long verifyTimeoutMillis) {
        this.verifyTimeoutMillis = verifyTimeoutMillis;
    }

    public long getLoadDataRetryDelayMillis() {
        return this.loadDataRetryDelayMillis;
    }

    public void setLoadDataRetryDelayMillis(long loadDataRetryDelayMillis) {
        this.loadDataRetryDelayMillis = loadDataRetryDelayMillis;
    }

    public long getLoadDataTimeoutMillis() {
        return this.loadDataTimeoutMillis;
    }

    public void setLoadDataTimeoutMillis(long loadDataTimeoutMillis) {
        this.loadDataTimeoutMillis = loadDataTimeoutMillis;
    }

    @Override
    protected String printConfig() {
        return "DistroConfig{syncDelayMillis=" + this.syncDelayMillis + ", syncTimeoutMillis=" + this.syncTimeoutMillis + ", syncRetryDelayMillis=" + this.syncRetryDelayMillis + ", verifyIntervalMillis=" + this.verifyIntervalMillis + ", verifyTimeoutMillis=" + this.verifyTimeoutMillis + ", loadDataRetryDelayMillis=" + this.loadDataRetryDelayMillis + ", loadDataTimeoutMillis=" + this.loadDataTimeoutMillis + '}';
    }
}

