/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.distro.monitor;

import com.alibaba.nacos.core.distributed.distro.monitor.DistroRecord;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public class DistroRecordsHolder {
    private static final DistroRecordsHolder INSTANCE = new DistroRecordsHolder();
    private final ConcurrentMap<String, DistroRecord> distroRecords = new ConcurrentHashMap<String, DistroRecord>();

    private DistroRecordsHolder() {
    }

    public static DistroRecordsHolder getInstance() {
        return INSTANCE;
    }

    public Optional<DistroRecord> getRecordIfExist(String type) {
        return Optional.ofNullable((DistroRecord)this.distroRecords.get(type));
    }

    public DistroRecord getRecord(String type) {
        return this.distroRecords.computeIfAbsent(type, s -> new DistroRecord(type));
    }

    public long getTotalSyncCount() {
        AtomicLong result = new AtomicLong();
        this.distroRecords.forEach((s, distroRecord) -> result.addAndGet(distroRecord.getTotalSyncCount()));
        return result.get();
    }

    public long getSuccessfulSyncCount() {
        AtomicLong result = new AtomicLong();
        this.distroRecords.forEach((s, distroRecord) -> result.addAndGet(distroRecord.getSuccessfulSyncCount()));
        return result.get();
    }

    public long getFailedSyncCount() {
        AtomicLong result = new AtomicLong();
        this.distroRecords.forEach((s, distroRecord) -> result.addAndGet(distroRecord.getFailedSyncCount()));
        return result.get();
    }

    public int getFailedVerifyCount() {
        AtomicInteger result = new AtomicInteger();
        this.distroRecords.forEach((s, distroRecord) -> result.addAndGet(distroRecord.getFailedVerifyCount()));
        return result.get();
    }
}

