/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.distributed.raft;

import com.alibaba.nacos.common.notify.Event;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.ExceptionUtil;
import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.common.utils.LoggerUtils;
import com.alibaba.nacos.consistency.ProtoMessageUtil;
import com.alibaba.nacos.consistency.RequestProcessor;
import com.alibaba.nacos.consistency.cp.RequestProcessor4CP;
import com.alibaba.nacos.consistency.entity.ReadRequest;
import com.alibaba.nacos.consistency.entity.Response;
import com.alibaba.nacos.consistency.entity.WriteRequest;
import com.alibaba.nacos.consistency.exception.ConsistencyException;
import com.alibaba.nacos.consistency.snapshot.LocalFileMeta;
import com.alibaba.nacos.consistency.snapshot.Reader;
import com.alibaba.nacos.consistency.snapshot.SnapshotOperation;
import com.alibaba.nacos.consistency.snapshot.Writer;
import com.alibaba.nacos.core.distributed.raft.JRaftServer;
import com.alibaba.nacos.core.distributed.raft.JSnapshotOperation;
import com.alibaba.nacos.core.distributed.raft.NacosClosure;
import com.alibaba.nacos.core.distributed.raft.RaftEvent;
import com.alibaba.nacos.core.distributed.raft.utils.JRaftUtils;
import com.alibaba.nacos.core.utils.Loggers;
import com.alipay.sofa.jraft.Closure;
import com.alipay.sofa.jraft.Iterator;
import com.alipay.sofa.jraft.Node;
import com.alipay.sofa.jraft.RouteTable;
import com.alipay.sofa.jraft.Status;
import com.alipay.sofa.jraft.conf.Configuration;
import com.alipay.sofa.jraft.core.StateMachineAdapter;
import com.alipay.sofa.jraft.entity.LeaderChangeContext;
import com.alipay.sofa.jraft.entity.LocalFileMetaOutter;
import com.alipay.sofa.jraft.error.RaftError;
import com.alipay.sofa.jraft.error.RaftException;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotReader;
import com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter;
import com.google.protobuf.Message;
import java.lang.invoke.LambdaMetafactory;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.slf4j.Logger;

class NacosStateMachine
extends StateMachineAdapter {
    protected final JRaftServer server;
    protected final RequestProcessor processor;
    private final AtomicBoolean isLeader = new AtomicBoolean(false);
    private final String groupId;
    private Collection<JSnapshotOperation> operations;
    private Node node;
    private volatile long term = -1L;
    private volatile String leaderIp = "unknown";

    NacosStateMachine(JRaftServer server, RequestProcessor4CP processor) {
        this.server = server;
        this.processor = processor;
        this.groupId = processor.group();
        this.adapterToJRaftSnapshot(processor.loadSnapshotOperate());
    }

    public void onApply(Iterator iter) {
        int index = 0;
        int applied = 0;
        NacosClosure closure = null;
        try {
            while (iter.hasNext()) {
                block13: {
                    Status status = Status.OK();
                    try {
                        Response response;
                        Message message;
                        if (iter.done() != null) {
                            closure = (NacosClosure)iter.done();
                            message = closure.getMessage();
                        } else {
                            ByteBuffer data = iter.getData();
                            message = ProtoMessageUtil.parse((byte[])data.array());
                            if (message instanceof ReadRequest) {
                                ++applied;
                                ++index;
                                iter.next();
                                continue;
                            }
                        }
                        LoggerUtils.printIfDebugEnabled((Logger)Loggers.RAFT, (String)"receive log : {}", (Object[])new Object[]{message});
                        if (message instanceof WriteRequest) {
                            response = this.processor.onApply((WriteRequest)message);
                            this.postProcessor(response, closure);
                        }
                        if (!(message instanceof ReadRequest)) break block13;
                        response = this.processor.onRequest((ReadRequest)message);
                        this.postProcessor(response, closure);
                    }
                    catch (Throwable e) {
                        ++index;
                        status.setError(RaftError.UNKNOWN, e.toString(), new Object[0]);
                        Optional.ofNullable(closure).ifPresent(closure1 -> closure1.setThrowable(e));
                        throw e;
                    }
                    finally {
                        Optional.ofNullable(closure).ifPresent(closure1 -> closure1.run(status));
                        continue;
                    }
                }
                ++applied;
                ++index;
                iter.next();
            }
        }
        catch (Throwable t) {
            Loggers.RAFT.error("processor : {}, stateMachine meet critical error: {}.", (Object)this.processor, (Object)t);
            iter.setErrorAndRollback((long)(index - applied), new Status(RaftError.ESTATEMACHINE, "StateMachine meet critical error: %s.", new Object[]{ExceptionUtil.getStackTrace((Throwable)t)}));
        }
    }

    public void setNode(Node node) {
        this.node = node;
    }

    public void onSnapshotSave(SnapshotWriter writer, Closure done) {
        for (JSnapshotOperation operation : this.operations) {
            try {
                operation.onSnapshotSave(writer, done);
            }
            catch (Throwable t) {
                Loggers.RAFT.error("There was an error saving the snapshot , error : {}, operation : {}", (Object)t, (Object)operation.info());
                throw t;
            }
        }
    }

    public boolean onSnapshotLoad(SnapshotReader reader) {
        for (JSnapshotOperation operation : this.operations) {
            try {
                if (operation.onSnapshotLoad(reader)) continue;
                Loggers.RAFT.error("Snapshot load failed on : {}", (Object)operation.info());
                return false;
            }
            catch (Throwable t) {
                Loggers.RAFT.error("Snapshot load failed on : {}, has error : {}", (Object)operation.info(), (Object)t);
                return false;
            }
        }
        return true;
    }

    public void onLeaderStart(long term) {
        super.onLeaderStart(term);
        this.term = term;
        this.isLeader.set(true);
        this.leaderIp = this.node.getNodeId().getPeerId().getEndpoint().toString();
        NotifyCenter.publishEvent((Event)RaftEvent.builder().groupId(this.groupId).leader(this.leaderIp).term(term).raftClusterInfo(this.allPeers()).build());
    }

    public void onLeaderStop(Status status) {
        super.onLeaderStop(status);
        this.isLeader.set(false);
    }

    public void onStartFollowing(LeaderChangeContext ctx) {
        this.term = ctx.getTerm();
        this.leaderIp = ctx.getLeaderId().getEndpoint().toString();
        NotifyCenter.publishEvent((Event)RaftEvent.builder().groupId(this.groupId).leader(this.leaderIp).term(ctx.getTerm()).raftClusterInfo(this.allPeers()).build());
    }

    public void onConfigurationCommitted(Configuration conf) {
        NotifyCenter.publishEvent((Event)RaftEvent.builder().groupId(this.groupId).raftClusterInfo(JRaftUtils.toStrings(conf.getPeers())).build());
    }

    public void onError(RaftException e) {
        super.onError(e);
        this.processor.onError((Throwable)e);
        NotifyCenter.publishEvent((Event)RaftEvent.builder().groupId(this.groupId).leader(this.leaderIp).term(this.term).raftClusterInfo(this.allPeers()).errMsg(e.toString()).build());
    }

    public boolean isLeader() {
        return this.isLeader.get();
    }

    private List<String> allPeers() {
        if (this.node == null) {
            return Collections.emptyList();
        }
        if (this.node.isLeader()) {
            return JRaftUtils.toStrings(this.node.listPeers());
        }
        return JRaftUtils.toStrings(RouteTable.getInstance().getConfiguration(this.node.getGroupId()).getPeers());
    }

    private void postProcessor(Response data, NacosClosure closure) {
        if (Objects.nonNull(closure)) {
            closure.setResponse(data);
        }
    }

    public long getTerm() {
        return this.term;
    }

    private void adapterToJRaftSnapshot(Collection<SnapshotOperation> userOperates) {
        ArrayList<1> tmp = new ArrayList<1>();
        for (final SnapshotOperation item : userOperates) {
            if (item == null) {
                Loggers.RAFT.error("Existing SnapshotOperation for null");
                continue;
            }
            tmp.add(new JSnapshotOperation(){

                @Override
                public void onSnapshotSave(SnapshotWriter writer, Closure done) {
                    Writer wCtx = new Writer(writer.getPath());
                    BiConsumer<Boolean, Throwable> callFinally = (arg_0, arg_1) -> this.lambda$onSnapshotSave$1(wCtx, writer, done, arg_0, arg_1);
                    item.onSnapshotSave(wCtx, callFinally);
                }

                @Override
                public boolean onSnapshotLoad(SnapshotReader reader) {
                    HashMap<String, LocalFileMeta> metaMap = new HashMap<String, LocalFileMeta>(reader.listFiles().size());
                    for (String fileName : reader.listFiles()) {
                        LocalFileMetaOutter.LocalFileMeta meta = (LocalFileMetaOutter.LocalFileMeta)reader.getFileMeta(fileName);
                        byte[] bytes = meta.getUserMeta().toByteArray();
                        LocalFileMeta fileMeta = bytes == null || bytes.length == 0 ? new LocalFileMeta() : (LocalFileMeta)JacksonUtils.toObj((byte[])bytes, LocalFileMeta.class);
                        metaMap.put(fileName, fileMeta);
                    }
                    Reader rCtx = new Reader(reader.getPath(), metaMap);
                    return item.onSnapshotLoad(rCtx);
                }

                @Override
                public String info() {
                    return item.toString();
                }

                /*
                 * Unable to fully structure code
                 */
                private /* synthetic */ void lambda$onSnapshotSave$1(Writer wCtx, SnapshotWriter writer, Closure done, Boolean result, Throwable t) {
                    results = new Boolean[wCtx.listFiles().size()];
                    index = new int[]{0};
                    wCtx.listFiles().forEach((BiConsumer<String, LocalFileMeta>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;Ljava/lang/Object;)V, lambda$onSnapshotSave$0(java.lang.Boolean[] int[] com.alipay.sofa.jraft.storage.snapshot.SnapshotWriter java.lang.String com.alibaba.nacos.consistency.snapshot.LocalFileMeta ), (Ljava/lang/String;Lcom/alibaba/nacos/consistency/snapshot/LocalFileMeta;)V)(this, (Boolean[])results, (int[])index, (SnapshotWriter)writer));
                    if (!result.booleanValue()) ** GOTO lbl-1000
                    if (Arrays.stream(results).allMatch((Predicate<Boolean>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, equals(java.lang.Object ), (Ljava/lang/Boolean;)Z)((Boolean)Boolean.TRUE))) {
                        v0 = Status.OK();
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = new Status(RaftError.EIO, "Fail to compress snapshot at %s, error is %s", new Object[]{writer.getPath(), t == null ? "" : t.getMessage()});
                    }
                    status = v0;
                    done.run(status);
                }

                private /* synthetic */ void lambda$onSnapshotSave$0(Boolean[] results, int[] index, SnapshotWriter writer, String file, LocalFileMeta meta) {
                    try {
                        int n = index[0];
                        index[0] = n + 1;
                        results[n] = writer.addFile(file, (Message)this.buildMetadata(meta));
                    }
                    catch (Exception e) {
                        throw new ConsistencyException((Throwable)e);
                    }
                }
            });
        }
        this.operations = Collections.unmodifiableList(tmp);
    }
}

