/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.monitor;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.monitor.NacosMeterRegistryCenter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.ImmutableTag;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public final class MetricsMonitor {
    private static final String METER_REGISTRY = "CORE_STABLE_REGISTRY";
    private static final DistributionSummary RAFT_READ_INDEX_FAILED;
    private static final DistributionSummary RAFT_FROM_LEADER;
    private static final Timer RAFT_APPLY_LOG_TIMER;
    private static final Timer RAFT_APPLY_READ_TIMER;
    private static AtomicInteger longConnection;
    private static GrpcServerExecutorMetric sdkServerExecutorMetric;
    private static GrpcServerExecutorMetric clusterServerExecutorMetric;
    private static Map<String, AtomicInteger> moduleConnectionCnt;

    private static void initGrpcServerExecutorMetric(List<Tag> tags, GrpcServerExecutorMetric metric) {
        ArrayList<Object> snapshotTags = new ArrayList<Tag>();
        snapshotTags.add(new ImmutableTag("name", "activeCount"));
        snapshotTags.addAll(tags);
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "grpc_server_executor", snapshotTags, metric.getActiveCount());
        snapshotTags = new ArrayList();
        snapshotTags.add((Tag)new ImmutableTag("name", "poolSize"));
        snapshotTags.addAll(tags);
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "grpc_server_executor", snapshotTags, metric.getPoolSize());
        snapshotTags = new ArrayList();
        snapshotTags.add((Tag)new ImmutableTag("name", "corePoolSize"));
        snapshotTags.addAll(tags);
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "grpc_server_executor", snapshotTags, metric.getCorePoolSize());
        snapshotTags = new ArrayList();
        snapshotTags.add((Tag)new ImmutableTag("name", "maximumPoolSize"));
        snapshotTags.addAll(tags);
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "grpc_server_executor", snapshotTags, metric.getMaximumPoolSize());
        snapshotTags = new ArrayList();
        snapshotTags.add((Tag)new ImmutableTag("name", "inQueueTaskCount"));
        snapshotTags.addAll(tags);
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "grpc_server_executor", snapshotTags, metric.getInQueueTaskCount());
        snapshotTags = new ArrayList();
        snapshotTags.add((Tag)new ImmutableTag("name", "taskCount"));
        snapshotTags.addAll(tags);
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "grpc_server_executor", snapshotTags, metric.getTaskCount());
        snapshotTags = new ArrayList();
        snapshotTags.add((Tag)new ImmutableTag("name", "completedTaskCount"));
        snapshotTags.addAll(tags);
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "grpc_server_executor", snapshotTags, metric.getCompletedTaskCount());
    }

    public static AtomicInteger getLongConnectionMonitor() {
        return longConnection;
    }

    public static void raftReadIndexFailed() {
        RAFT_READ_INDEX_FAILED.record(1.0);
    }

    public static void raftReadFromLeader() {
        RAFT_FROM_LEADER.record(1.0);
    }

    public static Timer getRaftApplyLogTimer() {
        return RAFT_APPLY_LOG_TIMER;
    }

    public static Timer getRaftApplyReadTimer() {
        return RAFT_APPLY_READ_TIMER;
    }

    public static DistributionSummary getRaftReadIndexFailed() {
        return RAFT_READ_INDEX_FAILED;
    }

    public static DistributionSummary getRaftFromLeader() {
        return RAFT_FROM_LEADER;
    }

    public static GrpcServerExecutorMetric getSdkServerExecutorMetric() {
        return sdkServerExecutorMetric;
    }

    public static GrpcServerExecutorMetric getClusterServerExecutorMetric() {
        return clusterServerExecutorMetric;
    }

    public static void refreshModuleConnectionCount(Map<String, Integer> connectionCnt) {
        connectionCnt.forEach((module, cnt) -> {
            AtomicInteger integer = moduleConnectionCnt.get(module);
            if (integer != null) {
                integer.set((int)cnt);
            } else {
                AtomicInteger newModuleConnCnt = new AtomicInteger((int)cnt);
                moduleConnectionCnt.put((String)module, newModuleConnCnt);
                NacosMeterRegistryCenter.gauge(METER_REGISTRY, "nacos_monitor", Arrays.asList(new ImmutableTag("module", module), new ImmutableTag("name", "longConnection")), moduleConnectionCnt.get(module));
            }
        });
        moduleConnectionCnt.forEach((module, cnt) -> {
            if (connectionCnt.containsKey(module)) {
                return;
            }
            cnt.set(0);
        });
    }

    public static Map<String, AtomicInteger> getModuleConnectionCnt() {
        return moduleConnectionCnt;
    }

    public static void recordGrpcRequestEvent(String requestClass, boolean success, int errorCode, String throwableClass, String module, long costTime) {
        NacosMeterRegistryCenter.timer(METER_REGISTRY, "grpc_server_requests", Arrays.asList(Tag.of((String)"requestClass", (String)requestClass), Tag.of((String)"success", (String)String.valueOf(success)), Tag.of((String)"errorCode", (String)String.valueOf(errorCode)), Tag.of((String)"throwableClass", (String)(StringUtils.isBlank((CharSequence)throwableClass) ? "None" : throwableClass)), Tag.of((String)"module", (String)(StringUtils.isBlank((CharSequence)module) ? "unknown" : module)))).record(costTime, TimeUnit.NANOSECONDS);
    }

    static {
        longConnection = new AtomicInteger();
        sdkServerExecutorMetric = new GrpcServerExecutorMetric("grpcSdkServer");
        clusterServerExecutorMetric = new GrpcServerExecutorMetric("grpcClusterServer");
        moduleConnectionCnt = new ConcurrentHashMap<String, AtomicInteger>();
        ImmutableTag immutableTag = new ImmutableTag("module", "core");
        ArrayList<Object> tags = new ArrayList<Tag>();
        tags.add(immutableTag);
        tags.add(new ImmutableTag("name", "raft_read_index_failed"));
        RAFT_READ_INDEX_FAILED = NacosMeterRegistryCenter.summary(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "raft_read_from_leader"));
        RAFT_FROM_LEADER = NacosMeterRegistryCenter.summary(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "raft_apply_log_timer"));
        RAFT_APPLY_LOG_TIMER = NacosMeterRegistryCenter.timer(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "raft_apply_read_timer"));
        RAFT_APPLY_READ_TIMER = NacosMeterRegistryCenter.timer(METER_REGISTRY, "nacos_monitor", tags);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("name", "longConnection"));
        NacosMeterRegistryCenter.gauge(METER_REGISTRY, "nacos_monitor", tags, longConnection);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("type", sdkServerExecutorMetric.getType()));
        MetricsMonitor.initGrpcServerExecutorMetric(tags, sdkServerExecutorMetric);
        tags = new ArrayList();
        tags.add((Tag)immutableTag);
        tags.add(new ImmutableTag("type", clusterServerExecutorMetric.getType()));
        MetricsMonitor.initGrpcServerExecutorMetric(tags, clusterServerExecutorMetric);
    }

    public static class GrpcServerExecutorMetric {
        private String type;
        private AtomicInteger activeCount = new AtomicInteger();
        private AtomicInteger corePoolSize = new AtomicInteger();
        private AtomicInteger poolSize = new AtomicInteger();
        private AtomicInteger maximumPoolSize = new AtomicInteger();
        private AtomicInteger inQueueTaskCount = new AtomicInteger();
        private AtomicLong completedTaskCount = new AtomicLong();
        private AtomicLong taskCount = new AtomicLong();

        private GrpcServerExecutorMetric(String type) {
            this.type = type;
        }

        public AtomicInteger getActiveCount() {
            return this.activeCount;
        }

        public AtomicInteger getCorePoolSize() {
            return this.corePoolSize;
        }

        public AtomicInteger getPoolSize() {
            return this.poolSize;
        }

        public AtomicInteger getMaximumPoolSize() {
            return this.maximumPoolSize;
        }

        public AtomicInteger getInQueueTaskCount() {
            return this.inQueueTaskCount;
        }

        public AtomicLong getCompletedTaskCount() {
            return this.completedTaskCount;
        }

        public AtomicLong getTaskCount() {
            return this.taskCount;
        }

        public String getType() {
            return this.type;
        }
    }
}

