/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.monitor.topn;

import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.core.monitor.topn.FixedSizePriorityQueue;
import com.alibaba.nacos.core.monitor.topn.TopNConfig;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class BaseTopNCounter<T> {
    private final Comparator<Pair<String, AtomicInteger>> comparator;
    protected ConcurrentMap<T, AtomicInteger> dataCount = new ConcurrentHashMap<T, AtomicInteger>();

    protected BaseTopNCounter() {
        this.comparator = Comparator.comparingInt(value -> ((AtomicInteger)value.getSecond()).get());
    }

    public List<Pair<String, AtomicInteger>> getTopNCounter(int topN) {
        if (!this.checkEnabled()) {
            this.reset();
            return Collections.emptyList();
        }
        ConcurrentMap<T, AtomicInteger> snapshot = this.dataCount;
        this.dataCount = new ConcurrentHashMap<T, AtomicInteger>(1);
        FixedSizePriorityQueue<Pair<String, AtomicInteger>> queue = new FixedSizePriorityQueue<Pair<String, AtomicInteger>>(topN, this.comparator);
        for (Object t : snapshot.keySet()) {
            queue.offer((Pair<String, AtomicInteger>)Pair.with((Object)this.keyToString(t), (Object)((AtomicInteger)snapshot.get(t))));
        }
        return queue.toList();
    }

    protected abstract String keyToString(T var1);

    public void increment(T t) {
        if (this.checkEnabled()) {
            this.increment(t, 1);
        }
    }

    public void increment(T t, int count) {
        if (this.checkEnabled()) {
            this.dataCount.computeIfAbsent(t, k -> new AtomicInteger(0)).addAndGet(count);
        }
    }

    public void set(T t, int count) {
        if (this.checkEnabled()) {
            this.dataCount.computeIfAbsent(t, k -> new AtomicInteger(0)).set(count);
        }
    }

    public void reset() {
        this.dataCount.clear();
    }

    protected boolean checkEnabled() {
        return TopNConfig.getInstance().isEnabled();
    }
}

