/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.paramcheck;

import com.alibaba.nacos.api.remote.request.Request;
import com.alibaba.nacos.common.paramcheck.ParamInfo;
import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.core.paramcheck.AbstractHttpParamExtractor;
import com.alibaba.nacos.core.paramcheck.AbstractRpcParamExtractor;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;

public class ExtractorManager {
    private static HashMap<Class<? extends AbstractRpcParamExtractor>, AbstractRpcParamExtractor> rpcManager = new HashMap();
    private static HashMap<Class<? extends AbstractHttpParamExtractor>, AbstractHttpParamExtractor> httpManager = new HashMap();

    public static AbstractRpcParamExtractor getRpcExtractor(Extractor extractor) {
        return rpcManager.computeIfAbsent(extractor.rpcExtractor(), key -> new DefaultGrpcExtractor());
    }

    public static AbstractHttpParamExtractor getHttpExtractor(Extractor extractor) {
        return httpManager.computeIfAbsent(extractor.httpExtractor(), key -> new DefaultHttpExtractor());
    }

    static {
        NacosServiceLoader.load(AbstractHttpParamExtractor.class).forEach(checker -> httpManager.put((Class<? extends AbstractHttpParamExtractor>)checker.getClass(), (AbstractHttpParamExtractor)checker));
        NacosServiceLoader.load(AbstractRpcParamExtractor.class).forEach(checker -> rpcManager.put((Class<? extends AbstractRpcParamExtractor>)checker.getClass(), (AbstractRpcParamExtractor)checker));
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    public static @interface Extractor {
        public Class<? extends AbstractHttpParamExtractor> httpExtractor() default DefaultHttpExtractor.class;

        public Class<? extends AbstractRpcParamExtractor> rpcExtractor() default DefaultGrpcExtractor.class;
    }

    public static class DefaultHttpExtractor
    extends AbstractHttpParamExtractor {
        @Override
        public List<ParamInfo> extractParam(HttpServletRequest params) {
            return Collections.emptyList();
        }
    }

    public static class DefaultGrpcExtractor
    extends AbstractRpcParamExtractor {
        @Override
        public List<ParamInfo> extractParam(Request request) {
            return Collections.emptyList();
        }
    }
}

