/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc.negotiator;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.core.remote.grpc.negotiator.NacosGrpcProtocolNegotiator;
import com.alibaba.nacos.core.remote.grpc.negotiator.ProtocolNegotiatorBuilder;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class AbstractProtocolNegotiatorBuilderSingleton
implements ProtocolNegotiatorBuilder {
    protected static final Map<String, ProtocolNegotiatorBuilder> BUILDER_MAP = new ConcurrentHashMap<String, ProtocolNegotiatorBuilder>();
    protected final String typePropertyKey;
    protected String actualType;

    public AbstractProtocolNegotiatorBuilderSingleton(String typePropertyKey) {
        this.typePropertyKey = typePropertyKey;
        this.actualType = EnvUtil.getProperty((String)typePropertyKey, (String)((String)this.defaultBuilderPair().getFirst()));
    }

    @Override
    public NacosGrpcProtocolNegotiator build() {
        ProtocolNegotiatorBuilder actualBuilder = BUILDER_MAP.get(this.actualType);
        if (null == actualBuilder) {
            Loggers.REMOTE.warn("Not found ProtocolNegotiatorBuilder for type {}, will use default type {}", (Object)this.actualType, this.defaultBuilderPair().getFirst());
            return ((ProtocolNegotiatorBuilder)this.defaultBuilderPair().getSecond()).build();
        }
        return actualBuilder.build();
    }

    protected abstract Pair<String, ProtocolNegotiatorBuilder> defaultBuilderPair();

    static {
        try {
            for (ProtocolNegotiatorBuilder each : NacosServiceLoader.load(ProtocolNegotiatorBuilder.class)) {
                BUILDER_MAP.put(each.type(), each);
                Loggers.REMOTE.info("Load ProtocolNegotiatorBuilder {} for type {}", (Object)each.getClass().getCanonicalName(), (Object)each.type());
            }
        }
        catch (Exception e) {
            Loggers.REMOTE.warn("Load ProtocolNegotiatorBuilder failed.", (Throwable)e);
        }
    }
}

