/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.tls;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.core.remote.tls.RpcServerSslContextRefresher;
import com.alibaba.nacos.core.remote.tls.RpcServerTlsConfig;
import com.alibaba.nacos.core.remote.tls.RpcServerTlsConfigFactory;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Collection;
import java.util.Properties;

public class RpcServerSslContextRefresherHolder {
    private static RpcServerSslContextRefresher sdkInstance;
    private static RpcServerSslContextRefresher clusterInstance;

    public static RpcServerSslContextRefresher getSdkInstance() {
        return sdkInstance;
    }

    public static RpcServerSslContextRefresher getClusterInstance() {
        return clusterInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void init() {
        Class<RpcServerSslContextRefresherHolder> clazz = RpcServerSslContextRefresherHolder.class;
        synchronized (RpcServerSslContextRefresherHolder.class) {
            Properties properties = EnvUtil.getProperties();
            RpcServerTlsConfig clusterServerTlsConfig = RpcServerTlsConfigFactory.getInstance().createClusterConfig(properties);
            RpcServerTlsConfig sdkServerTlsConfig = RpcServerTlsConfigFactory.getInstance().createSdkConfig(properties);
            Collection refreshers = NacosServiceLoader.load(RpcServerSslContextRefresher.class);
            sdkInstance = RpcServerSslContextRefresherHolder.getSslContextRefresher(refreshers, sdkServerTlsConfig);
            clusterInstance = RpcServerSslContextRefresherHolder.getSslContextRefresher(refreshers, clusterServerTlsConfig);
            Loggers.REMOTE.info("RpcServerSslContextRefresher initialization completed.");
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    private static RpcServerSslContextRefresher getSslContextRefresher(Collection<RpcServerSslContextRefresher> refreshers, RpcServerTlsConfig serverTlsConfig) {
        String refresherName = serverTlsConfig.getSslContextRefresher();
        RpcServerSslContextRefresher instance = null;
        if (StringUtils.isNotBlank((String)refresherName)) {
            for (RpcServerSslContextRefresher contextRefresher : refreshers) {
                if (!refresherName.equals(contextRefresher.getName())) continue;
                instance = contextRefresher;
                Loggers.REMOTE.info("RpcServerSslContextRefresher initialized using {}.", (Object)contextRefresher.getClass().getSimpleName());
                break;
            }
            if (instance == null) {
                Loggers.REMOTE.warn("Failed to find RpcServerSslContextRefresher with name {}.", (Object)refresherName);
            }
        } else {
            Loggers.REMOTE.info("Ssl Context auto refresh is not supported.");
        }
        return instance;
    }

    static {
        RpcServerSslContextRefresherHolder.init();
    }
}

