/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.tls;

import com.alibaba.nacos.common.remote.client.RpcTlsConfigFactory;
import com.alibaba.nacos.core.remote.tls.RpcServerTlsConfig;
import java.util.Properties;

public class RpcServerTlsConfigFactory
implements RpcTlsConfigFactory {
    private static RpcServerTlsConfigFactory instance;

    private RpcServerTlsConfigFactory() {
    }

    public static synchronized RpcServerTlsConfigFactory getInstance() {
        if (instance == null) {
            instance = new RpcServerTlsConfigFactory();
        }
        return instance;
    }

    public RpcServerTlsConfig createSdkConfig(Properties properties) {
        return this.createServerTlsConfig(properties, "nacos.remote.server.rpc.tls");
    }

    public RpcServerTlsConfig createClusterConfig(Properties properties) {
        return this.createServerTlsConfig(properties, "nacos.remote.peer.rpc.tls");
    }

    public RpcServerTlsConfig createServerTlsConfig(Properties properties, String prefix) {
        RpcServerTlsConfig tlsConfig = new RpcServerTlsConfig();
        tlsConfig.setEnableTls(this.getBooleanProperty(properties, prefix + ".enableTls", false));
        tlsConfig.setMutualAuthEnable(this.getBooleanProperty(properties, prefix + ".mutualAuthEnable", false));
        tlsConfig.setProtocols(properties.getProperty(prefix + ".protocols"));
        tlsConfig.setCiphers(properties.getProperty(prefix + ".ciphers"));
        tlsConfig.setTrustCollectionCertFile(properties.getProperty(prefix + ".trustCollectionCertFile"));
        tlsConfig.setCertChainFile(properties.getProperty(prefix + ".certChainFile"));
        tlsConfig.setCertPrivateKey(properties.getProperty(prefix + ".certPrivateKey"));
        tlsConfig.setTrustAll(this.getBooleanProperty(properties, prefix + ".trustAll", true));
        tlsConfig.setCertPrivateKeyPassword(properties.getProperty(prefix + ".certPrivateKeyPassword"));
        tlsConfig.setSslProvider(properties.getProperty(prefix + ".sslProvider"));
        tlsConfig.setSslContextRefresher(properties.getProperty(prefix + ".sslContextRefresher"));
        tlsConfig.setCompatibility(this.getBooleanProperty(properties, prefix + ".compatibility", true));
        return tlsConfig;
    }
}

